// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class TlsAttributes
{
    /// <summary>
    /// String indicating the <a href="https://datatracker.ietf.org/doc/html/rfc5246#appendix-A.5">cipher</a> used during the current connection.
    /// </summary>
    /// <remarks>
    /// The values allowed for <c>tls.cipher</c> MUST be one of the <c>Descriptions</c> of the <a href="https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#table-tls-parameters-4">registered TLS Cipher Suits</a>.
    /// </remarks>
    public const string AttributeTlsCipher = "tls.cipher";

    /// <summary>
    /// PEM-encoded stand-alone certificate offered by the client. This is usually mutually-exclusive of <c>client.certificate_chain</c> since this value also exists in that list.
    /// </summary>
    public const string AttributeTlsClientCertificate = "tls.client.certificate";

    /// <summary>
    /// Array of PEM-encoded certificates that make up the certificate chain offered by the client. This is usually mutually-exclusive of <c>client.certificate</c> since that value should be the first certificate in the chain.
    /// </summary>
    public const string AttributeTlsClientCertificateChain = "tls.client.certificate_chain";

    /// <summary>
    /// Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
    /// </summary>
    public const string AttributeTlsClientHashMd5 = "tls.client.hash.md5";

    /// <summary>
    /// Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
    /// </summary>
    public const string AttributeTlsClientHashSha1 = "tls.client.hash.sha1";

    /// <summary>
    /// Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
    /// </summary>
    public const string AttributeTlsClientHashSha256 = "tls.client.hash.sha256";

    /// <summary>
    /// Distinguished name of <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.6">subject</a> of the issuer of the x.509 certificate presented by the client.
    /// </summary>
    public const string AttributeTlsClientIssuer = "tls.client.issuer";

    /// <summary>
    /// A hash that identifies clients based on how they perform an SSL/TLS handshake.
    /// </summary>
    public const string AttributeTlsClientJa3 = "tls.client.ja3";

    /// <summary>
    /// Date/Time indicating when client certificate is no longer considered valid.
    /// </summary>
    public const string AttributeTlsClientNotAfter = "tls.client.not_after";

    /// <summary>
    /// Date/Time indicating when client certificate is first considered valid.
    /// </summary>
    public const string AttributeTlsClientNotBefore = "tls.client.not_before";

    /// <summary>
    /// Deprecated, use <c>server.address</c> instead.
    /// </summary>
    [Obsolete("Replaced by <c>server.address</c>.")]
    public const string AttributeTlsClientServerName = "tls.client.server_name";

    /// <summary>
    /// Distinguished name of subject of the x.509 certificate presented by the client.
    /// </summary>
    public const string AttributeTlsClientSubject = "tls.client.subject";

    /// <summary>
    /// Array of ciphers offered by the client during the client hello.
    /// </summary>
    public const string AttributeTlsClientSupportedCiphers = "tls.client.supported_ciphers";

    /// <summary>
    /// String indicating the curve used for the given cipher, when applicable.
    /// </summary>
    public const string AttributeTlsCurve = "tls.curve";

    /// <summary>
    /// Boolean flag indicating if the TLS negotiation was successful and transitioned to an encrypted tunnel.
    /// </summary>
    public const string AttributeTlsEstablished = "tls.established";

    /// <summary>
    /// String indicating the protocol being tunneled. Per the values in the <a href="https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids">IANA registry</a>, this string should be lower case.
    /// </summary>
    public const string AttributeTlsNextProtocol = "tls.next_protocol";

    /// <summary>
    /// Normalized lowercase protocol name parsed from original string of the negotiated <a href="https://www.openssl.org/docs/man1.1.1/man3/SSL_get_version.html#RETURN-VALUES">SSL/TLS protocol version</a>.
    /// </summary>
    public const string AttributeTlsProtocolName = "tls.protocol.name";

    /// <summary>
    /// Numeric part of the version parsed from the original string of the negotiated <a href="https://www.openssl.org/docs/man1.1.1/man3/SSL_get_version.html#RETURN-VALUES">SSL/TLS protocol version</a>.
    /// </summary>
    public const string AttributeTlsProtocolVersion = "tls.protocol.version";

    /// <summary>
    /// Boolean flag indicating if this TLS connection was resumed from an existing TLS negotiation.
    /// </summary>
    public const string AttributeTlsResumed = "tls.resumed";

    /// <summary>
    /// PEM-encoded stand-alone certificate offered by the server. This is usually mutually-exclusive of <c>server.certificate_chain</c> since this value also exists in that list.
    /// </summary>
    public const string AttributeTlsServerCertificate = "tls.server.certificate";

    /// <summary>
    /// Array of PEM-encoded certificates that make up the certificate chain offered by the server. This is usually mutually-exclusive of <c>server.certificate</c> since that value should be the first certificate in the chain.
    /// </summary>
    public const string AttributeTlsServerCertificateChain = "tls.server.certificate_chain";

    /// <summary>
    /// Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
    /// </summary>
    public const string AttributeTlsServerHashMd5 = "tls.server.hash.md5";

    /// <summary>
    /// Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
    /// </summary>
    public const string AttributeTlsServerHashSha1 = "tls.server.hash.sha1";

    /// <summary>
    /// Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
    /// </summary>
    public const string AttributeTlsServerHashSha256 = "tls.server.hash.sha256";

    /// <summary>
    /// Distinguished name of <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.6">subject</a> of the issuer of the x.509 certificate presented by the client.
    /// </summary>
    public const string AttributeTlsServerIssuer = "tls.server.issuer";

    /// <summary>
    /// A hash that identifies servers based on how they perform an SSL/TLS handshake.
    /// </summary>
    public const string AttributeTlsServerJa3s = "tls.server.ja3s";

    /// <summary>
    /// Date/Time indicating when server certificate is no longer considered valid.
    /// </summary>
    public const string AttributeTlsServerNotAfter = "tls.server.not_after";

    /// <summary>
    /// Date/Time indicating when server certificate is first considered valid.
    /// </summary>
    public const string AttributeTlsServerNotBefore = "tls.server.not_before";

    /// <summary>
    /// Distinguished name of subject of the x.509 certificate presented by the server.
    /// </summary>
    public const string AttributeTlsServerSubject = "tls.server.subject";

    /// <summary>
    /// Normalized lowercase protocol name parsed from original string of the negotiated <a href="https://www.openssl.org/docs/man1.1.1/man3/SSL_get_version.html#RETURN-VALUES">SSL/TLS protocol version</a>.
    /// </summary>
    public static class TlsProtocolNameValues
    {
        /// <summary>
        /// ssl.
        /// </summary>
        public const string Ssl = "ssl";

        /// <summary>
        /// tls.
        /// </summary>
        public const string Tls = "tls";
    }
}
