// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class VcsAttributes
{
    /// <summary>
    /// The ID of the change (pull request/merge request) if applicable. This is usually a unique (within repository) identifier generated by the VCS system.
    /// </summary>
    public const string AttributeVcsRepositoryChangeId = "vcs.repository.change.id";

    /// <summary>
    /// The human readable title of the change (pull request/merge request). This title is often a brief summary of the change and may get merged in to a ref as the commit summary.
    /// </summary>
    public const string AttributeVcsRepositoryChangeTitle = "vcs.repository.change.title";

    /// <summary>
    /// The name of the <a href="https://git-scm.com/docs/gitglossary#def_ref">reference</a> such as <strong>branch</strong> or <strong>tag</strong> in the repository.
    /// </summary>
    public const string AttributeVcsRepositoryRefName = "vcs.repository.ref.name";

    /// <summary>
    /// The revision, literally <a href="https://www.merriam-webster.com/dictionary/revision">revised version</a>, The revision most often refers to a commit object in Git, or a revision number in SVN.
    /// </summary>
    /// <remarks>
    /// The revision can be a full <a href="https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf">hash value (see glossary)</a>,
    /// of the recorded change to a ref within a repository pointing to a
    /// commit <a href="https://git-scm.com/docs/git-commit">commit</a> object. It does
    /// not necessarily have to be a hash; it can simply define a
    /// <a href="https://svnbook.red-bean.com/en/1.7/svn.tour.revs.specifiers.html">revision number</a>
    /// which is an integer that is monotonically increasing. In cases where
    /// it is identical to the <c>ref.name</c>, it SHOULD still be included. It is
    /// up to the implementer to decide which value to set as the revision
    /// based on the VCS system and situational context.
    /// </remarks>
    public const string AttributeVcsRepositoryRefRevision = "vcs.repository.ref.revision";

    /// <summary>
    /// The type of the <a href="https://git-scm.com/docs/gitglossary#def_ref">reference</a> in the repository.
    /// </summary>
    public const string AttributeVcsRepositoryRefType = "vcs.repository.ref.type";

    /// <summary>
    /// The <a href="https://en.wikipedia.org/wiki/URL">URL</a> of the repository providing the complete address in order to locate and identify the repository.
    /// </summary>
    public const string AttributeVcsRepositoryUrlFull = "vcs.repository.url.full";

    /// <summary>
    /// The type of the <a href="https://git-scm.com/docs/gitglossary#def_ref">reference</a> in the repository.
    /// </summary>
    public static class VcsRepositoryRefTypeValues
    {
        /// <summary>
        /// <a href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddefbranchabranch">branch</a>.
        /// </summary>
        public const string Branch = "branch";

        /// <summary>
        /// <a href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddeftagatag">tag</a>.
        /// </summary>
        public const string Tag = "tag";
    }
}
