# OpenTelemetry .NET Diagnostic: OTEL1001

## Overview

This is an Experimental API diagnostic covering the following APIs:

* `LoggerProvider.GetLogger`
* `Logger`
* `LogRecordAttributeList`
* `LogRecordData`
* `LogRecordSeverity`
* `Sdk.CreateLoggerProviderBuilder`

Experimental APIs may be changed or removed in the future.

## Details

The OpenTelemetry Specification defines a [Logs Bridge
API](https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/logs/bridge-api.md).

The Logs Bridge API is used by library authors to build log appenders which
route messages from different log frameworks into OpenTelemetry.

Today the OpenTelemetry .NET log pipeline is built on top of the
Microsoft.Extensions.Logging `ILogger` \ `ILoggerProvider` \ `ILoggerFactory`
APIs.

We are exposing these APIs gather feedback about their usefulness. An
alternative approach may be taken which would be to append into `ILogger`
instead of OpenTelemetry directly.

## LoggerProvider API

The OpenTelemetry Specification defines a `LoggerProvider` API. See
[OTEL1000](./OTEL1000.md) for details about the `LoggerProvider` implementation
status.
