# OpenTelemetry .NET Diagnostic: OTEL1004

## Overview

This is an Experimental API diagnostic covering the following APIs:

* `ExemplarReservoir`
* `FixedSizeExemplarReservoir`
* `ExemplarMeasurement<T>`
* `MetricStreamConfiguration.ExemplarReservoirFactory.get`
* `MetricStreamConfiguration.ExemplarReservoirFactory.set`

Experimental APIs may be changed or removed in the future.

## Details

The OpenTelemetry Specification defines an [ExemplarReservoir
API](https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/sdk.md#exemplarreservoir)
and a mechanism for configuring `ExemplarReservoir` via the [View
API](https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/sdk.md#stream-configuration)
in the Metrics SDK.

From the specification:

> The SDK MUST provide a mechanism for SDK users to provide their own
> ExemplarReservoir implementation. This extension MUST be configurable on a
> metric View, although individual reservoirs MUST still be instantiated per
> metric-timeseries...

We are exposing these APIs experimentally for the following reasons:

* `FixedSizeExemplarReservoir` is not part of the spec. It is meant to help
  custom reservoir authors and takes care of correctly creating & updating
  `struct Exemplar`s (managing tag filtering when views are used), handles
  `Exemplar` collection, and ensures all operations are safe to be called
  concurrency (spec requirement). We want to see if this is helpful and meets
  the needs of users.

* There is currently no way to use
  `MetricStreamConfiguration.ExemplarReservoirFactory` to switch a metric to a
  different built-in reservoir (`AlignedHistogramBucketExemplarReservoir` or
  `SimpleFixedSizeExemplarReservoir`). This is something supported by the spec
  but we want to understand the use cases and needs before exposing these types.
  Also it seems the default reservoirs may change.

* There is currently no way to get access to the bucket index inside a reservoir
  when a measurement is recorded against a histogram with explicit bounds. The
  spec says the reservoir should calculate this given the
  definition/configuration of the bounds but the SDK has already done this
  computation. It seems unncessarily complicated to expose the configuration and
  wasteful to do the work twice. We want to understand the types of algorithms
  which users will want to implement before exposing something.

**TL;DR** We want to gather feedback on the usability of the API and for the
need(s) in general for custom reservoirs before exposing a stable API.

## Provide feedback

Please provide feedback on [this
issue](https://github.com/open-telemetry/opentelemetry-dotnet/issues/5629) if
you need stable support for custom `ExemplarReservoir`s. The feedback will help
inform decisions about what to expose stable and when.
