require 'fluent/plugin/parser'
require 'crack'

module Fluent
  module Plugin
    # Filter plugin to change and flatten xml from OnTap
    class EmsEventParser < Parser
      Plugin.register_parser('ems_event', self)

      def configure(conf)
        super
      end

      def parse(text)
        begin
          xml_hash = Crack::XML.parse(text)
        rescue StandardError => e
          $stdout.write e
          return nil
        end
        parameters = xml_hash.dig(
          'netapp',
          'ems_message_info',
          'parameters',
          'parameter'
        )
        return nil if parameters.nil?

        better_params = {}
        parameters = [parameters] unless parameters.is_a? Array
        parameters.each do |parameter|
          better_params[parameter['name']] = parameter['value']
        end
        xml_hash['netapp']['ems_message_info']['parameters'] = better_params
        #Kusto seems to have an issue with two fields being called version, so we're just removing the xml netapp version one.
        xml_hash["netapp"].delete("version")
        record = {}
        record['message'] = xml_hash
        yield nil, record
      end
    end
  end
end
