require 'helper'
require 'fluent/test/driver/parser'
require 'fluent/plugin/parser_ems_event'

# Testing ems event filter plugin
class EmsEventsParserTest < Test::Unit::TestCase
  def setup
    Fluent::Test.setup
  end

  def test_convert_ems_xml_to_hash
    d = Fluent::Test::Driver::Parser.new(Fluent::Plugin::EmsEventParser)
    d.instance.parse(
      "<netapp version='1.0' xmlns='http://www.netapp.com/filer/admin'>
          <ems-message-origin>
              <cluster-uuid>f81d4fae-7dec-11d0-a765-00a0c91e6bf6</cluster-uuid>
              <node-uuid>5f29f789-349e-11e5-b0cf-b58c613d92fc</node-uuid>
          </ems-message-origin>
          <ems-message-info>
              <node>node1</node>
              <message-name>raid.disk.capacity.info</message-name>
              <version>1</version>
              <parameters>
                  <parameter>
                      <name>actual</name>
                      <value>11.45 GB</value>
                  </parameter>
                  <parameter>
                      <name>limit</name>
                      <value>6.00 TB</value>
                  </parameter>
              </parameters>
              <seq-num>420</seq-num>
              <severity>informational</severity>
              <time>1432932082</time>
              <event>raid.disk.capacity.info: System capacity visible is 11.45 GB of the 6.00 TB maximum. </event>
              <num-suppressed-since-last>0</num-suppressed-since-last>
              <ems-severity>info</ems-severity>
              <event-xml-len>215</event-xml-len>
              <source>statd</source>
          </ems-message-info>
      </netapp>"
    ) { |_, record|
      assert_equal(
        {
          'message' => {
            'netapp' => {
              'ems_message_origin' => {
                'cluster_uuid' => 'f81d4fae-7dec-11d0-a765-00a0c91e6bf6',
                'node_uuid' => '5f29f789-349e-11e5-b0cf-b58c613d92fc'
              },
              'ems_message_info' => {
                'node' => 'node1',
                'message_name' => 'raid.disk.capacity.info',
                'version' => '1',
                'parameters' => {
                  'actual' => '11.45 GB',
                  'limit' => '6.00 TB'
                },
                'seq_num' => '420',
                'severity' => 'informational',
                'time' => '1432932082',
                'event' => 'raid.disk.capacity.info: System capacity visible is 11.45 GB of the 6.00 TB maximum. ',
                'num_suppressed_since_last' => '0',
                'ems_severity' => 'info',
                'event_xml_len' => '215',
                'source' => 'statd'
              },
              'xmlns' => 'http://www.netapp.com/filer/admin'
            }
          }
        }, record
      )
    }
  end

  def test_removing_xml_version
    d = Fluent::Test::Driver::Parser.new(Fluent::Plugin::EmsEventParser)
    d.instance.parse(
      "<netapp version='1.0' xmlns='http://www.netapp.com/filer/admin'>
          <ems-message-origin>
              <cluster-uuid>f81d4fae-7dec-11d0-a765-00a0c91e6bf6</cluster-uuid>
              <node-uuid>5f29f789-349e-11e5-b0cf-b58c613d92fc</node-uuid>
          </ems-message-origin>
          <ems-message-info>
              <node>node1</node>
              <message-name>raid.disk.capacity.info</message-name>
              <version>1</version>
              <parameters>
                  <parameter>
                      <name>actual</name>
                      <value>11.45 GB</value>
                  </parameter>
                  <parameter>
                      <name>limit</name>
                      <value>6.00 TB</value>
                  </parameter>
              </parameters>
              <seq-num>420</seq-num>
              <severity>informational</severity>
              <time>1432932082</time>
              <event>raid.disk.capacity.info: System capacity visible is 11.45 GB of the 6.00 TB maximum. </event>
              <num-suppressed-since-last>0</num-suppressed-since-last>
              <ems-severity>info</ems-severity>
              <event-xml-len>215</event-xml-len>
              <source>statd</source>
          </ems-message-info>
      </netapp>"
    ) { |_, record|
      assert_equal(
        {
          'message' => {
            'netapp' => {
              'ems_message_origin' => {
                'cluster_uuid' => 'f81d4fae-7dec-11d0-a765-00a0c91e6bf6',
                'node_uuid' => '5f29f789-349e-11e5-b0cf-b58c613d92fc'
              },
              'ems_message_info' => {
                'node' => 'node1',
                'message_name' => 'raid.disk.capacity.info',
                'version' => '1',
                'parameters' => {
                  'actual' => '11.45 GB',
                  'limit' => '6.00 TB'
                },
                'seq_num' => '420',
                'severity' => 'informational',
                'time' => '1432932082',
                'event' => 'raid.disk.capacity.info: System capacity visible is 11.45 GB of the 6.00 TB maximum. ',
                'num_suppressed_since_last' => '0',
                'ems_severity' => 'info',
                'event_xml_len' => '215',
                'source' => 'statd'
              },
              'xmlns' => 'http://www.netapp.com/filer/admin'
            }
          }
        }, record
      )
    }
  end

  def test_convert_emg_xml_to_hash
    d = Fluent::Test::Driver::Parser.new(Fluent::Plugin::EmsEventParser)
    d.instance.parse(
      "<!DOCTYPE netapp SYSTEM 'file:/etc/netapp_gx.dtd'>
      <netapp version='1.0' xmlns='http://www.netapp.com/filer/admin'>
        <ems-message-origin>
          <cluster-uuid>5b8c6247-3353-11e8-8659-00a098d60b50</cluster-uuid>
          <node-uuid>c324e2ff-31f0-11e8-8659-00a098d60b50</node-uuid>
        </ems-message-origin>
        <ems-message-info>
          <node>DC11-21355-0107-STO-01</node>
          <message-name>callhome.sfo.takeover.panic</message-name>
          <version>1</version>
          <parameters>
          <parameter>
          <name>subject</name>
          <value>1</value>
          </parameter>
          </parameters>
          <seq-num>53905</seq-num>
          <severity>emergency</severity>
          <time>1530887561</time>
          <event>callhome.sfo.takeover.panic: Call home for CONTROLLER TAKEOVER COMPLETE PANIC </event>
          <num-suppressed-since-last>0</num-suppressed-since-last>
          <ems-severity>node_fault</ems-severity>
          <event-xml-len>206</event-xml-len>
          <source>notifyd</source>
        </ems-message-info>
      </netapp>"
    ) { |_, record|
      assert_equal(
        { 'message' =>
          { 'netapp' =>
            { 'ems_message_info' =>
              { 'ems_severity' => 'node_fault',
                'event' =>
                  'callhome.sfo.takeover.panic: Call home for CONTROLLER TAKEOVER COMPLETE PANIC ',
                'event_xml_len' => '206',
                'message_name' => 'callhome.sfo.takeover.panic',
                'node' => 'DC11-21355-0107-STO-01',
                'num_suppressed_since_last' => '0',
                'parameters' => { 'subject' => '1' },
                'seq_num' => '53905',
                'severity' => 'emergency',
                'source' => 'notifyd',
                'time' => '1530887561',
                'version' => '1' },
              'ems_message_origin' =>
                { 'cluster_uuid' => '5b8c6247-3353-11e8-8659-00a098d60b50',
                  'node_uuid' => 'c324e2ff-31f0-11e8-8659-00a098d60b50' },
              'xmlns' => 'http://www.netapp.com/filer/admin' } } }, record
            )
    }
  end
end
