require 'helper'
require 'fluent/test/driver/filter'
require 'fluent/plugin/filter_prometheus_alert'
require 'test/unit'
require 'mocha/test_unit'

# Testing the Ems Metric Filter
class PrometheusAlertFilterTest < Test::Unit::TestCase
  CONFIG = %(
    type prometheus_alert
    host 127.0.0.1
    port 8125
  )

  def setup
    Fluent::Test.setup
    @time = Fluent::Engine.now
  end

  def create_driver(conf = '')
    Fluent::Test::Driver::Filter
      .new(Fluent::Plugin::PrometheusAlertFilter).configure(conf, syntax: :v1)
  end


  def test_harvest_metrics
    d = create_driver CONFIG

    d.run(default_tag: 'test') do
      json_string = '{"receiver":"deadmanssnitch2","status":"firing","alerts":[{"status":"firing","labels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"annotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"startsAt":"2018-04-26T23:31:25.69263445Z","endsAt":"0001-01-01T00:00:00Z","generatorURL":"http://kube-prometheus-prometheus.default:9090/graph?g0.expr=absent%28up%7Bjob%3D%22kube-controller-manager%22%7D+%3D%3D+1%29&g0.tab=1"}],"groupLabels":{"alertname":"K8SControllerManagerDown"},"commonLabels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"commonAnnotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"externalURL":"http://kube-prometheus-alertmanager.default:9093","datacenter": "TestCenter","version":"4","groupKey":"{}/{severity=\"critical\"}:{alertname=\"K8SControllerManagerDown\"}"}'
      json = JSON.parse(json_string)
      d.feed(
        json
      )
    end

    assert_equal [
      [{ 'Dims' =>
        { 'AlertName' => 'K8SControllerManagerDown',
          'Component' => nil,
          'Container' => nil,
          'DataCenter' => 'TestCenter',
          'Description' =>
       'There is no running K8S controller manager. Deployments and replication controllers are not making progress.',
          'Job' => nil,
          'Pod' => nil,
          'Severity' => 'critical',
          'Status' => 'firing' },
         'Metric' => 'PrometheusAlert',
         'Namespace' => 'Demo' }]
    ], (d.filtered.map { |x| x[1] })
  end

  def test_logs_without_datacenter_variable
    d = create_driver CONFIG

    d.run(default_tag: 'test') do
      json_string = '{"receiver":"deadmanssnitch2","status":"firing","alerts":[{"status":"firing","labels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"annotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"startsAt":"2018-04-26T23:31:25.69263445Z","endsAt":"0001-01-01T00:00:00Z","generatorURL":"http://kube-prometheus-prometheus.default:9090/graph?g0.expr=absent%28up%7Bjob%3D%22kube-controller-manager%22%7D+%3D%3D+1%29&g0.tab=1"}],"groupLabels":{"alertname":"K8SControllerManagerDown"},"commonLabels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"commonAnnotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"externalURL":"http://kube-prometheus-alertmanager.default:9093","version":"4","groupKey":"{}/{severity=\"critical\"}:{alertname=\"K8SControllerManagerDown\"}"}'
      json = JSON.parse(json_string)
      d.feed(
        json
      )
    end

    assert_equal [
      [{ 'Dims' =>
        { 'AlertName' => 'K8SControllerManagerDown',
          'Component' => nil,
          'Container' => nil,
          'DataCenter' => 'attn: Datacenter Variable not set',
          'Description' =>
       'There is no running K8S controller manager. Deployments and replication controllers are not making progress.',
          'Job' => nil,
          'Pod' => nil,
          'Severity' => 'critical',
          'Status' => 'firing' },
         'Metric' => 'PrometheusAlert',
         'Namespace' => 'Demo' }]
    ], (d.filtered.map { |x| x[1] })
  end
  def test_metrics_without_datacenter_variable
    d = create_driver CONFIG

    d.run(default_tag: 'test') do
      json_string = '{"receiver":"deadmanssnitch2","status":"firing","alerts":[{"status":"firing","labels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"annotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"startsAt":"2018-04-26T23:31:25.69263445Z","endsAt":"0001-01-01T00:00:00Z","generatorURL":"http://kube-prometheus-prometheus.default:9090/graph?g0.expr=absent%28up%7Bjob%3D%22kube-controller-manager%22%7D+%3D%3D+1%29&g0.tab=1"}],"groupLabels":{"alertname":"K8SControllerManagerDown"},"commonLabels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"commonAnnotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"externalURL":"http://kube-prometheus-alertmanager.default:9093","version":"4","groupKey":"{}/{severity=\"critical\"}:{alertname=\"K8SControllerManagerDown\"}"}'
      json = JSON.parse(json_string)
      d.feed(
        json
      )
    end

    assert_equal [
      [{ 'Dims' =>
        { 'AlertName' => 'K8SControllerManagerDown',
          'Component' => nil,
          'Container' => nil,
          'DataCenter' => 'attn: Datacenter Variable not set',
          'Description' =>
       'There is no running K8S controller manager. Deployments and replication controllers are not making progress.',
          'Job' => nil,
          'Pod' => nil,
          'Severity' => 'critical',
          'Status' => 'firing' },
         'Metric' => 'PrometheusAlert',
         'Namespace' => 'Demo' }]
    ], (d.filtered.map { |x| x[1] })
  end

  def test_metrics_sending_without_pod
    d = create_driver CONFIG

    # Mock the TCPSocket
    mock_socket = mock()
    mock_socket.expects(:close).at_least_once
    mock_socket.expects(:write).with do |payload|
      payload.include?('"Metric":"PrometheusAlert"') &&
      payload.include?('"Namespace":"Demo"') &&
      payload.include?('"AlertName":"K8SControllerManagerDown"')
      payload.include?('"Pod":"missingPodNameFromAlert"')
    end

    # Mock the start_tcpsocket method to set @tcpsocket to the mock_socket
    d.instance.instance_variable_set(:@tcpsocket, mock_socket)
#    d.instance.stubs(:start_tcpsocket).returns(mock_socket)

    d.run(default_tag: 'test') do
      json_string = '{"receiver":"deadmanssnitch2","status":"firing","alerts":[{"status":"firing","labels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"annotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"startsAt":"2018-04-26T23:31:25.69263445Z","endsAt":"0001-01-01T00:00:00Z","generatorURL":"http://kube-prometheus-prometheus.default:9090/graph?g0.expr=absent%28up%7Bjob%3D%22kube-controller-manager%22%7D+%3D%3D+1%29&g0.tab=1"}],"groupLabels":{"alertname":"K8SControllerManagerDown"},"commonLabels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"commonAnnotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"externalURL":"http://kube-prometheus-alertmanager.default:9093","datacenter": "TestCenter","version":"4","groupKey":"{}/{severity=\"critical\"}:{alertname=\"K8SControllerManagerDown\"}"}'
      json = JSON.parse(json_string)
      d.feed(
        json
      )
    end
  end

  def test_metrics_sending_with_pod
    d = create_driver CONFIG

    # Mock the TCPSocket
    mock_socket = mock()
    mock_socket.expects(:close).at_least_once
    mock_socket.expects(:write).with do |payload|
      payload.include?('"Metric":"PrometheusAlert"') &&
      payload.include?('"Namespace":"Demo"') &&
      payload.include?('"AlertName":"K8SControllerManagerDown"')
      payload.include?('"Pod":"PodName-X999"')
    end

    # Mock the start_tcpsocket method to set @tcpsocket to the mock_socket
    d.instance.instance_variable_set(:@tcpsocket, mock_socket)
#    d.instance.stubs(:start_tcpsocket).returns(mock_socket)

    d.run(default_tag: 'test') do
      json_string = '{"receiver":"deadmanssnitch2","status":"firing","alerts":[{"status":"firing","labels":{"alertname":"K8SControllerManagerDown","severity":"critical","pod":"PodName-X999"},"annotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"startsAt":"2018-04-26T23:31:25.69263445Z","endsAt":"0001-01-01T00:00:00Z","generatorURL":"http://kube-prometheus-prometheus.default:9090/graph?g0.expr=absent%28up%7Bjob%3D%22kube-controller-manager%22%7D+%3D%3D+1%29&g0.tab=1"}],"groupLabels":{"alertname":"K8SControllerManagerDown"},"commonLabels":{"alertname":"K8SControllerManagerDown","severity":"critical"},"commonAnnotations":{"description":"There is no running K8S controller manager. Deployments and replication controllers are not making progress.","runbook":"https://coreos.com/tectonic/docs/latest/troubleshooting/controller-recovery.html#recovering-a-controller-manager","summary":"Controller manager is down"},"externalURL":"http://kube-prometheus-alertmanager.default:9093","datacenter": "TestCenter","version":"4","groupKey":"{}/{severity=\"critical\"}:{alertname=\"K8SControllerManagerDown\"}"}'
      json = JSON.parse(json_string)
      d.feed(
        json
      )
    end
  end
end
