# Configuration: Output (v0.12 style)

Here is a sample configuration for old fluentd v0.12. It works with fluentd v1 too but not recommended for it.

    <match pattern>
      @type s3

      aws_key_id YOUR_AWS_KEY_ID
      aws_sec_key YOUR_AWS_SECRET_KEY
      s3_bucket YOUR_S3_BUCKET_NAME
      s3_region ap-northeast-1

      path logs/
      s3_object_key_format %{path}%{time_slice}_%{index}.%{file_extension}
      buffer_path /var/log/fluent/s3
      time_slice_format %Y%m%d-%H
      time_slice_wait 10m
      utc
      format json
    </match>

If you want to embed tag in [`path`](output.md#path) / [`s3_object_key_format`](output.md#s3_object_key_format), you need to use `fluent-plugin-forest` plugin.

The following explanations are about the differences with v1. Other parameters are same with v1, see [Configuration: Output](output.md) for them.

## format (for v0.12)

    @format json
    include_time_key true
    time_key log_time # default is time

This parameter is for v0.12. Use [`<format>`](https://docs.fluentd.org/configuration/format-section) and [`<inject>`](https://docs.fluentd.org/configuration/inject-section) for v1.

## buffer_path (for v0.12)

path prefix of the files to buffer logs.

This parameter is for v0.12. Use [`<buffer>`](https://docs.fluentd.org/configuration/buffer-section)'s `path` in v1.

## time_slice_format (for v0.12)

Format of the time used as the file name. Default is '%Y%m%d'. Use
'%Y%m%d%H' to split files hourly.

This parameter is for v0.12. Use [buffer placeholder](https://docs.fluentd.org/configuration/buffer-section#placeholders) for [`path`](output.md#path) / [`s3_object_key_format`](output.md#s3_object_key_format) in v1.

## time_slice_wait (for v0.12)

The time to wait old logs. Default is 10 minutes. Specify larger value if
old logs may reach.

This parameter is for v0.12. Use [`<buffer>`](https://docs.fluentd.org/configuration/buffer-section)'s `timekey_wait` in v1.
