# frozen_string_literal: true

require_relative "lib/linux/utmpx/version"

Gem::Specification.new do |spec|
  spec.name          = "linux-utmpx"
  spec.version       = Linux::Utmpx::VERSION
  spec.authors       = ["Kentaro Hayashi"]
  spec.email         = ["kenhys@gmail.com"]

  spec.summary       = "Helper library to read utmp, wtmp login records"
  spec.description   = "Library to read login records from /var/log/wtmp, /var/run/utmp"
  spec.homepage      = "https://github.com/fluent-plugins-nursery/linux-utmpx"
  spec.license       = "MIT"
  spec.required_ruby_version = Gem::Requirement.new(">= 2.4.0")

  spec.metadata["homepage_uri"] = spec.homepage
  spec.metadata["source_code_uri"] = "https://github.com/fluent-plugins-nursery/linux-utmpx"
  spec.metadata["changelog_uri"] = "https://github.com/fluent-plugins-nursery/linux-utmpx/CHANGELOG.md"

  # Specify which files should be added to the gem when it is released.
  # The `git ls-files -z` loads the files in the RubyGem that have been added into git.
  spec.files = Dir.chdir(File.expand_path(__dir__)) do
    `git ls-files -z`.split("\x0").reject { |f| f.match(%r{\A(?:test|spec|features)/}) }
  end
  spec.bindir        = "exe"
  spec.executables   = spec.files.grep(%r{\Aexe/}) { |f| File.basename(f) }
  spec.require_paths = ["lib"]

  # Uncomment to register a new dependency of your gem
  # spec.add_dependency "example-gem", "~> 1.0"
  spec.add_dependency "bindata", "~> 2.4.8"

  spec.add_development_dependency "test-unit", "~> 3.4.0"
  # For more information and examples about making a new gem, checkout our
  # guide at: https://bundler.io/guides/creating_gem.html
end
