# frozen_string_literal: true

require "logger"
require "objspace"
require "ffi"
require "json"

require "rdkafka/version"
require "rdkafka/helpers/time"
require "rdkafka/helpers/oauth"
require "rdkafka/abstract_handle"
require "rdkafka/admin"
require "rdkafka/admin/create_topic_handle"
require "rdkafka/admin/create_topic_report"
require "rdkafka/admin/delete_groups_handle"
require "rdkafka/admin/delete_groups_report"
require "rdkafka/admin/delete_topic_handle"
require "rdkafka/admin/delete_topic_report"
require "rdkafka/admin/create_partitions_handle"
require "rdkafka/admin/create_partitions_report"
require "rdkafka/admin/create_acl_handle"
require "rdkafka/admin/create_acl_report"
require "rdkafka/admin/delete_acl_handle"
require "rdkafka/admin/delete_acl_report"
require "rdkafka/admin/describe_acl_handle"
require "rdkafka/admin/describe_acl_report"
require "rdkafka/admin/describe_configs_handle"
require "rdkafka/admin/describe_configs_report"
require "rdkafka/admin/incremental_alter_configs_handle"
require "rdkafka/admin/incremental_alter_configs_report"
require "rdkafka/admin/acl_binding_result"
require "rdkafka/admin/config_binding_result"
require "rdkafka/admin/config_resource_binding_result"
require "rdkafka/bindings"
require "rdkafka/callbacks"
require "rdkafka/config"
require "rdkafka/consumer"
require "rdkafka/consumer/headers"
require "rdkafka/consumer/message"
require "rdkafka/consumer/partition"
require "rdkafka/consumer/topic_partition_list"
require "rdkafka/error"
require "rdkafka/metadata"
require "rdkafka/native_kafka"
require "rdkafka/producer"
require "rdkafka/producer/delivery_handle"
require "rdkafka/producer/delivery_report"

# Main Rdkafka namespace of this gem
module Rdkafka
end
