/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import com.github.blagerweij.sessionlock.SessionLockService;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;

public class OracleLockService
extends SessionLockService {
    static final String SQL_ALLOCATE_LOCK = "{ call dbms_lock.allocate_unique(?, ?) }";
    static final String SQL_GET_LOCK = "{ ? = call dbms_lock.request(?, ?, ?) }";
    static final String SQL_RELEASE_LOCK = "{ ? = call dbms_lock.release(?) }";
    static final String SQL_LOCK_INFO = "select l.sid, current_timestamp - numToDSInterval(l.ctime,'second'), s.USERNAME, s.OSUSER, s.MACHINE from gv$lock l join gv$session s on l.sid = s.SID where l.type = 'UL'   and l.id1 = ?";

    @Override
    public boolean supports(Database database) {
        return database instanceof OracleDatabase;
    }

    private String getChangeLogLockName() {
        return (this.database.getLiquibaseSchemaName() + "." + this.database.getDatabaseChangeLogLockTableName()).toUpperCase(Locale.ROOT);
    }

    private String allocateLock(Connection con) throws SQLException {
        try (CallableStatement stmt = con.prepareCall(SQL_ALLOCATE_LOCK);){
            stmt.setString(1, this.getChangeLogLockName());
            stmt.registerOutParameter(2, 12);
            stmt.executeQuery();
            String string = stmt.getString(2);
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean acquireLock(Connection con) throws SQLException, LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CASE]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void releaseLock(Connection con) throws SQLException, LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException {
        String lockHandle = this.allocateLock(con);
        if (lockHandle.length() < 10) return null;
        try {
            int lockId = Integer.parseInt(lockHandle.substring(0, 10));
            try (PreparedStatement stmt = con.prepareStatement(SQL_LOCK_INFO);){
                stmt.setInt(1, lockId);
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return null;
                    DatabaseChangeLogLock databaseChangeLogLock = new DatabaseChangeLogLock(lockId, (Date)rs.getTimestamp(2), this.lockedBy(rs));
                    return databaseChangeLogLock;
                }
            }
        }
        catch (NumberFormatException e) {
            OracleLockService.getLog(this.getClass()).warning("could not parse lock handle " + lockHandle, (Throwable)e);
        }
        return null;
    }

    private String lockedBy(ResultSet rs) throws SQLException {
        return String.format("(session_id=%d)(current_user=%s)(os_user=%s)(host=%s)", rs.getInt(1), rs.getString(3), rs.getString(4), rs.getString(5));
    }
}

