/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.wavefront;

import brave.handler.SpanHandler;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.tracing.reporter.wavefront.SpanMetrics;
import io.micrometer.tracing.reporter.wavefront.WavefrontBraveSpanHandler;
import io.micrometer.tracing.reporter.wavefront.WavefrontOtelSpanExporter;
import io.micrometer.tracing.reporter.wavefront.WavefrontSpanHandler;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.wavefront.MeterRegistrySpanMetrics;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontProperties;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontSenderConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, WavefrontAutoConfiguration.class})
@ConditionalOnClass(value={WavefrontSender.class, WavefrontSpanHandler.class})
@EnableConfigurationProperties(value={WavefrontProperties.class})
@Import(value={WavefrontSenderConfiguration.class})
public class WavefrontTracingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={WavefrontSender.class})
    @ConditionalOnEnabledTracing
    WavefrontSpanHandler wavefrontSpanHandler(WavefrontProperties properties, WavefrontSender wavefrontSender, SpanMetrics spanMetrics, ApplicationTags applicationTags) {
        return new WavefrontSpanHandler(properties.getSender().getMaxQueueSize(), wavefrontSender, spanMetrics, properties.getSourceOrDefault(), applicationTags, properties.getTraceDerivedCustomTagKeys());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SpanExporter.class})
    static class WavefrontOpenTelemetry {
        WavefrontOpenTelemetry() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledTracing
        WavefrontOtelSpanExporter wavefrontOtelSpanExporter(WavefrontSpanHandler wavefrontSpanHandler) {
            return new WavefrontOtelSpanExporter(wavefrontSpanHandler);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SpanHandler.class})
    static class WavefrontBrave {
        WavefrontBrave() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledTracing
        WavefrontBraveSpanHandler wavefrontBraveSpanHandler(WavefrontSpanHandler wavefrontSpanHandler) {
            return new WavefrontBraveSpanHandler(wavefrontSpanHandler);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={MeterRegistry.class})
    static class NoopSpanMetricsConfiguration {
        NoopSpanMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        SpanMetrics meterRegistrySpanMetrics() {
            return SpanMetrics.NOOP;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MeterRegistry.class})
    static class MeterRegistrySpanMetricsConfiguration {
        MeterRegistrySpanMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MeterRegistrySpanMetrics meterRegistrySpanMetrics(MeterRegistry meterRegistry) {
            return new MeterRegistrySpanMetrics(meterRegistry);
        }
    }
}

