/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.exec;

import ch.vorburger.exec.CheckingConsoleOutputStream;
import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.exec.MultiOutputStream;
import ch.vorburger.exec.OutputStreamLogDispatcher;
import ch.vorburger.exec.OutputStreamType;
import ch.vorburger.exec.RollingLogOutputStream;
import ch.vorburger.exec.SLF4jLogOutputStream;
import ch.vorburger.mariadb4j.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedProcess {
    private static final Logger logger = LoggerFactory.getLogger(ManagedProcess.class);
    private static final int INVALID_EXITVALUE = -559038737;
    private final CommandLine commandLine;
    private final Executor executor = new DefaultExecutor();
    private final DefaultExecuteResultHandler resultHandler = new LoggingExecuteResultHandler();
    private final ExecuteWatchdog watchDog = new ExecuteWatchdog(-1L);
    private final ProcessDestroyer shutdownHookProcessDestroyer = new LoggingShutdownHookProcessDestroyer();
    private final Map<String, String> environment;
    private final InputStream input;
    private final boolean destroyOnShutdown;
    private final int consoleBufferMaxLines;
    private final OutputStreamLogDispatcher outputStreamLogDispatcher;
    private boolean isAlive = false;
    private String procShortName;
    private RollingLogOutputStream console;
    private MultiOutputStream stdouts;
    private MultiOutputStream stderrs;

    ManagedProcess(CommandLine commandLine, File directory, Map<String, String> environment, InputStream input, boolean destroyOnShutdown, int consoleBufferMaxLines, OutputStreamLogDispatcher outputStreamLogDispatcher) {
        this.commandLine = commandLine;
        this.environment = environment;
        this.input = input != null ? this.buffer(input) : null;
        if (directory != null) {
            this.executor.setWorkingDirectory(directory);
        }
        this.executor.setWatchdog(this.watchDog);
        this.destroyOnShutdown = destroyOnShutdown;
        this.consoleBufferMaxLines = consoleBufferMaxLines;
        this.outputStreamLogDispatcher = outputStreamLogDispatcher;
    }

    protected BufferedInputStream buffer(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream == null");
        }
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public synchronized void start() throws ManagedProcessException {
        this.startPreparation();
        this.startExecute();
    }

    protected synchronized void startPreparation() throws ManagedProcessException {
        if (this.isAlive()) {
            throw new ManagedProcessException(this.procLongName() + " is still running, use another ManagedProcess instance to launch another one");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Starting {}", (Object)this.procLongName());
        }
        this.stdouts = new MultiOutputStream();
        this.stderrs = new MultiOutputStream();
        PumpStreamHandler outputHandler = new PumpStreamHandler((OutputStream)this.stdouts, (OutputStream)this.stderrs, this.input);
        this.executor.setStreamHandler((ExecuteStreamHandler)outputHandler);
        String pid = this.procShortName();
        this.stdouts.addOutputStream((OutputStream)((Object)new SLF4jLogOutputStream(logger, pid, OutputStreamType.STDOUT, this.outputStreamLogDispatcher)));
        this.stderrs.addOutputStream((OutputStream)((Object)new SLF4jLogOutputStream(logger, pid, OutputStreamType.STDERR, this.outputStreamLogDispatcher)));
        if (this.consoleBufferMaxLines > 0) {
            this.console = new RollingLogOutputStream(this.consoleBufferMaxLines);
            this.stdouts.addOutputStream((OutputStream)((Object)this.console));
            this.stderrs.addOutputStream((OutputStream)((Object)this.console));
        }
        if (this.destroyOnShutdown) {
            this.executor.setProcessDestroyer(this.shutdownHookProcessDestroyer);
        }
        if (this.commandLine.isFile()) {
            try {
                Util.forceExecutable(this.getExecutableFile());
            }
            catch (Exception e) {
                throw new ManagedProcessException("Unable to make command executable", e);
            }
        } else {
            logger.debug(this.commandLine.getExecutable() + " is not a java.io.File, so it won't be made executable (which MAY be a problem on *NIX, but not for sure)");
        }
    }

    public File getExecutableFile() {
        return new File(this.commandLine.getExecutable());
    }

    protected synchronized void startExecute() throws ManagedProcessException {
        try {
            this.executor.execute(this.commandLine, this.environment, (ExecuteResultHandler)this.resultHandler);
        }
        catch (IOException e) {
            throw new ManagedProcessException("Launch failed: " + this.commandLine, e);
        }
        this.isAlive = true;
        try {
            this.wait(100L);
        }
        catch (InterruptedException e) {
            throw this.handleInterruptedException(e);
        }
        this.checkResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAndWaitForConsoleMessageMaxMs(String messageInConsole, long maxWaitUntilReturning) throws ManagedProcessException {
        this.startPreparation();
        CheckingConsoleOutputStream checkingConsoleOutputStream = new CheckingConsoleOutputStream(messageInConsole);
        if (this.stdouts != null && this.stderrs != null) {
            this.stdouts.addOutputStream((OutputStream)((Object)checkingConsoleOutputStream));
            this.stderrs.addOutputStream((OutputStream)((Object)checkingConsoleOutputStream));
        }
        long timeAlreadyWaited = 0L;
        int SLEEP_TIME_MS = 50;
        logger.info("Thread will wait for \"{}\" to appear in Console output of process {} for max. " + maxWaitUntilReturning + "ms", (Object)messageInConsole, (Object)this.procLongName());
        this.startExecute();
        try {
            while (!checkingConsoleOutputStream.hasSeenIt() && this.isAlive()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw this.handleInterruptedException(e);
                }
                if ((timeAlreadyWaited += 50L) <= maxWaitUntilReturning) continue;
                logger.warn("Timed out waiting for \"\"{}\"\" after {}ms (returning false)", (Object)messageInConsole, (Object)maxWaitUntilReturning);
                boolean bl = false;
                return bl;
            }
            if (!checkingConsoleOutputStream.hasSeenIt()) {
                throw new ManagedProcessException(this.getUnexpectedExitMsg(messageInConsole));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.stdouts != null && this.stderrs != null) {
                this.stdouts.removeOutputStream((OutputStream)((Object)checkingConsoleOutputStream));
                this.stderrs.removeOutputStream((OutputStream)((Object)checkingConsoleOutputStream));
            }
        }
    }

    protected String getUnexpectedExitMsg(String messageInConsole) {
        return "Asked to wait for \"" + messageInConsole + "\" from " + this.procLongName() + ", but it already exited! (without that message in console)" + this.getLastConsoleLines();
    }

    protected ManagedProcessException handleInterruptedException(InterruptedException e) throws ManagedProcessException {
        String message = "Huh?! InterruptedException should normally never happen here..." + this.procLongName();
        logger.error(message, (Throwable)e);
        return new ManagedProcessException(message, e);
    }

    protected void checkResult() throws ManagedProcessException {
        ExecuteException e;
        if (this.resultHandler.hasResult() && (e = this.resultHandler.getException()) != null) {
            logger.error(this.procLongName() + " failed");
            throw new ManagedProcessException(this.procLongName() + " failed, exitValue=" + this.exitValue() + this.getLastConsoleLines(), (Throwable)e);
        }
    }

    public void destroy() throws ManagedProcessException {
        if (!this.isAlive) {
            throw new ManagedProcessException(this.procLongName() + " was already stopped (or never started)");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Going to destroy {}", (Object)this.procLongName());
        }
        this.watchDog.destroyProcess();
        try {
            this.resultHandler.waitFor();
        }
        catch (InterruptedException e) {
            throw this.handleInterruptedException(e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Successfully destroyed {}", (Object)this.procLongName());
        }
        this.isAlive = false;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public int exitValue() throws ManagedProcessException {
        try {
            return this.resultHandler.getExitValue();
        }
        catch (IllegalStateException e) {
            throw new ManagedProcessException("Exit Value not (yet) available for " + this.procLongName(), e);
        }
    }

    public int waitForExit() throws ManagedProcessException {
        logger.info("Thread is now going to wait for this process to terminate itself: {}", (Object)this.procLongName());
        return this.waitForExitMaxMsWithoutLog(-1L);
    }

    public int waitForExitMaxMs(long maxWaitUntilReturning) throws ManagedProcessException {
        logger.info("Thread is now going to wait max. {}ms for process to terminate itself: {}", (Object)maxWaitUntilReturning, (Object)this.procLongName());
        return this.waitForExitMaxMsWithoutLog(maxWaitUntilReturning);
    }

    protected int waitForExitMaxMsWithoutLog(long maxWaitUntilReturning) throws ManagedProcessException {
        this.assertWaitForIsValid();
        try {
            if (maxWaitUntilReturning != -1L) {
                this.resultHandler.waitFor(maxWaitUntilReturning);
                this.checkResult();
                if (!this.isAlive()) {
                    return this.exitValue();
                }
                return -559038737;
            }
            this.resultHandler.waitFor();
            this.checkResult();
            return this.exitValue();
        }
        catch (InterruptedException e) {
            throw this.handleInterruptedException(e);
        }
    }

    public void waitForExitMaxMsOrDestroy(long maxWaitUntilDestroyTimeout) throws ManagedProcessException {
        this.waitForExitMaxMs(maxWaitUntilDestroyTimeout);
        if (this.isAlive()) {
            logger.info("Process didn't exit within max. {}ms, so going to destroy it now: {}", (Object)maxWaitUntilDestroyTimeout, (Object)this.procLongName());
            this.destroy();
        }
    }

    protected void assertWaitForIsValid() throws ManagedProcessException {
        if (!this.isAlive() && !this.resultHandler.hasResult()) {
            throw new ManagedProcessException("Asked to waitFor " + this.procLongName() + ", but it was never even start()'ed!");
        }
    }

    public String getConsole() {
        if (this.console != null) {
            return this.console.getRecentLines();
        }
        return "";
    }

    public String getLastConsoleLines() {
        return ", last " + this.consoleBufferMaxLines + " lines of console:\n" + this.getConsole();
    }

    private String procShortName() {
        if (this.procShortName == null) {
            File exec = this.getExecutableFile();
            this.procShortName = exec.getName();
        }
        return this.procShortName;
    }

    private String procLongName() {
        return "Program " + this.commandLine.toString() + (this.executor.getWorkingDirectory() == null ? "" : " (in working directory " + this.executor.getWorkingDirectory().getAbsolutePath() + ")");
    }

    public static class LoggingShutdownHookProcessDestroyer
    extends ShutdownHookProcessDestroyer {
        public void run() {
            logger.info("Shutdown Hook: JVM is about to exit! Going to kill destroyOnShutdown processes...");
            super.run();
        }
    }

    public class LoggingExecuteResultHandler
    extends DefaultExecuteResultHandler {
        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            logger.info(ManagedProcess.this.procLongName() + " just exited, with value " + exitValue);
            ManagedProcess.this.isAlive = false;
        }

        public void onProcessFailed(ExecuteException e) {
            super.onProcessFailed(e);
            if (!ManagedProcess.this.watchDog.killedProcess()) {
                logger.error(ManagedProcess.this.procLongName() + " failed unexpectedly", (Throwable)e);
            }
            ManagedProcess.this.isAlive = false;
        }
    }
}

