/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.query;

import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStackTraceLogger
implements StatementInspector {
    public static final String ORG_HIBERNATE = "org.hibernate";
    public static String TAB = "\t";
    public static String NEW_LINE = System.getProperty("line.separator");
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStackTraceLogger.class);
    private final String packageNamePrefix;

    public QueryStackTraceLogger(String packageNamePrefix) {
        this.packageNamePrefix = packageNamePrefix;
    }

    public String inspect(String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(QueryStackTraceLogger.stackTraceStringUpTo(this.packageNamePrefix, sql));
        }
        return null;
    }

    private static String stackTraceStringUpTo(String endPackageNamePrefix, String query) {
        return StackWalker.getInstance().walk(stream -> {
            StringBuilder buffer = new StringBuilder();
            buffer.append("This SQL query: [\n\t");
            buffer.append(query);
            buffer.append("\n]\n");
            buffer.append("was generated by Hibernate like this: [\n");
            AtomicBoolean firstMatch = new AtomicBoolean(false);
            stream.skip(2L).dropWhile(stackFrame -> !stackFrame.getClassName().startsWith(ORG_HIBERNATE)).takeWhile(stackFrame -> {
                if (stackFrame.getClassName().contains(endPackageNamePrefix)) {
                    if (firstMatch.get()) {
                        return false;
                    }
                    firstMatch.set(true);
                    return true;
                }
                return !firstMatch.get();
            }).forEach(stackFrame -> buffer.append(TAB).append(stackFrame.toStackTraceElement()).append(NEW_LINE));
            buffer.append(']');
            return buffer.toString();
        });
    }
}

