/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.exec;

import java.util.Collection;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.exec.LogOutputStream;

class RollingLogOutputStream
extends LogOutputStream {
    private final Collection<String> ringBuffer;

    RollingLogOutputStream(int maxLines) {
        this.ringBuffer = new CircularFifoQueue(maxLines);
    }

    protected synchronized void processLine(String line, int level) {
        this.ringBuffer.add(line);
    }

    public synchronized String getRecentLines() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.ringBuffer) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(line);
        }
        return sb.toString();
    }
}

