/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.exec;

import ch.vorburger.exec.OutputStreamLogDispatcher;
import ch.vorburger.exec.OutputStreamType;
import org.apache.commons.exec.LogOutputStream;
import org.slf4j.Logger;
import org.slf4j.event.Level;

class SLF4jLogOutputStream
extends LogOutputStream {
    private final OutputStreamLogDispatcher dispatcher;
    private final Logger logger;
    private final OutputStreamType type;
    private final String pid;

    protected SLF4jLogOutputStream(Logger logger, String pid, OutputStreamType type, OutputStreamLogDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.type = type;
        this.pid = pid;
    }

    protected void processLine(String line, int level) {
        Level logLevel = this.dispatcher.dispatch(this.type, line);
        switch (logLevel) {
            case TRACE: {
                this.logger.trace("{}: {}", (Object)this.pid, (Object)line);
                break;
            }
            case DEBUG: {
                this.logger.debug("{}: {}", (Object)this.pid, (Object)line);
                break;
            }
            case INFO: {
                this.logger.info("{}: {}", (Object)this.pid, (Object)line);
                break;
            }
            case WARN: {
                this.logger.warn("{}: {}", (Object)this.pid, (Object)line);
                break;
            }
            case ERROR: {
                this.logger.error("{}: {}", (Object)this.pid, (Object)line);
                break;
            }
        }
    }
}

