/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j.springframework;

import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.MariaDB4jService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.Lifecycle;

public class MariaDB4jSpringService
extends MariaDB4jService
implements Lifecycle {
    public static final String PORT = "mariaDB4j.port";
    public static final String SOCKET = "mariaDB4j.socket";
    public static final String DATA_DIR = "mariaDB4j.dataDir";
    public static final String BASE_DIR = "mariaDB4j.baseDir";
    public static final String LIB_DIR = "mariaDB4j.libDir";
    public static final String UNPACK = "mariaDB4j.unpack";
    protected ManagedProcessException lastException;

    @Value(value="${mariaDB4j.port:-1}")
    public void setDefaultPort(int port) {
        if (port != -1) {
            this.getConfiguration().setPort(port);
        }
    }

    @Value(value="${mariaDB4j.socket:NA}")
    public void setDefaultSocket(String socket) {
        if (!"NA".equals(socket)) {
            this.getConfiguration().setSocket(socket);
        }
    }

    @Value(value="${mariaDB4j.dataDir:NA}")
    public void setDefaultDataDir(String dataDir) {
        if (!"NA".equals(dataDir)) {
            this.getConfiguration().setDataDir(dataDir);
        }
    }

    @Value(value="${mariaDB4j.baseDir:NA}")
    public void setDefaultBaseDir(String baseDir) {
        if (!"NA".equals(baseDir)) {
            this.getConfiguration().setBaseDir(baseDir);
        }
    }

    @Value(value="${mariaDB4j.libDir:NA}")
    public void setDefaultLibDir(String libDir) {
        if (!"NA".equals(libDir)) {
            this.getConfiguration().setLibDir(libDir);
        }
    }

    @Value(value="${mariaDB4j.unpack:#{null}}")
    public void setDefaultIsUnpackingFromClasspath(Boolean unpack) {
        if (unpack != null) {
            this.getConfiguration().setUnpackingFromClasspath(unpack);
        }
    }

    @Override
    public void start() {
        try {
            super.start();
        }
        catch (ManagedProcessException e) {
            this.lastException = e;
            throw new IllegalStateException("MariaDB4jSpringService start() failed", e);
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        catch (ManagedProcessException e) {
            this.lastException = e;
            throw new IllegalStateException("MariaDB4jSpringService stop() failed", e);
        }
    }

    public ManagedProcessException getLastException() {
        return this.lastException;
    }
}

