/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.JsonPatchProcessor;
import com.google.common.base.Strings;
import java.util.List;

class ApplyProcessor
implements JsonPatchProcessor {
    private JsonNode target;

    ApplyProcessor(JsonNode target) {
        this.target = target.deepCopy();
    }

    public JsonNode result() {
        return this.target;
    }

    @Override
    public void move(List<String> fromPath, List<String> toPath) {
        JsonNode parentNode = this.getParentNode(fromPath);
        String field = fromPath.get(fromPath.size() - 1).replaceAll("\"", "");
        JsonNode valueNode = parentNode.isArray() ? parentNode.get(Integer.parseInt(field)) : parentNode.get(field);
        this.remove(fromPath);
        this.add(toPath, valueNode);
    }

    @Override
    public void add(List<String> path, JsonNode value) {
        if (path.isEmpty()) {
            throw new JsonPatchApplicationException("[ADD Operation] path is empty , path : ");
        }
        JsonNode parentNode = this.getParentNode(path);
        if (parentNode == null) {
            throw new JsonPatchApplicationException("[ADD Operation] noSuchPath in source, path provided : " + path);
        }
        String fieldToReplace = path.get(path.size() - 1).replaceAll("\"", "");
        if (fieldToReplace.equals("") && path.size() == 1) {
            this.target = value;
        } else {
            if (!parentNode.isContainerNode()) {
                throw new JsonPatchApplicationException("[ADD Operation] parent is not a container in source, path provided : " + path + " | node : " + parentNode);
            }
            if (parentNode.isArray()) {
                this.addToArray(path, value, parentNode);
            } else {
                this.addToObject(path, parentNode, value);
            }
        }
    }

    private void addToObject(List<String> path, JsonNode node, JsonNode value) {
        ObjectNode target = (ObjectNode)node;
        String key = path.get(path.size() - 1).replaceAll("\"", "");
        target.put(key, value);
    }

    private void addToArray(List<String> path, JsonNode value, JsonNode parentNode) {
        ArrayNode target = (ArrayNode)parentNode;
        String idxStr = path.get(path.size() - 1);
        if ("-".equals(idxStr)) {
            target.add(value);
        } else {
            int idx = this.arrayIndex(idxStr.replaceAll("\"", ""), target.size());
            target.insert(idx, value);
        }
    }

    @Override
    public void replace(List<String> path, JsonNode value) {
        if (path.isEmpty()) {
            throw new JsonPatchApplicationException("[Replace Operation] path is empty");
        }
        JsonNode parentNode = this.getParentNode(path);
        if (parentNode == null) {
            throw new JsonPatchApplicationException("[Replace Operation] noSuchPath in source, path provided : " + path);
        }
        String fieldToReplace = path.get(path.size() - 1).replaceAll("\"", "");
        if (Strings.isNullOrEmpty((String)fieldToReplace) && path.size() == 1) {
            this.target = value;
        } else if (parentNode.isObject()) {
            ((ObjectNode)parentNode).put(fieldToReplace, value);
        } else if (parentNode.isArray()) {
            ((ArrayNode)parentNode).set(this.arrayIndex(fieldToReplace, parentNode.size() - 1), value);
        } else {
            throw new JsonPatchApplicationException("[Replace Operation] noSuchPath in source, path provided : " + path);
        }
    }

    @Override
    public void remove(List<String> path) {
        if (path.isEmpty()) {
            throw new JsonPatchApplicationException("[Remove Operation] path is empty");
        }
        JsonNode parentNode = this.getParentNode(path);
        if (parentNode == null) {
            throw new JsonPatchApplicationException("[Remove Operation] noSuchPath in source, path provided : " + path);
        }
        String fieldToRemove = path.get(path.size() - 1).replaceAll("\"", "");
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(fieldToRemove);
        } else if (parentNode.isArray()) {
            ((ArrayNode)parentNode).remove(this.arrayIndex(fieldToRemove, parentNode.size() - 1));
        } else {
            throw new JsonPatchApplicationException("[Remove Operation] noSuchPath in source, path provided : " + path);
        }
    }

    private JsonNode getParentNode(List<String> fromPath) {
        List<String> pathToParent = fromPath.subList(0, fromPath.size() - 1);
        return this.getNode(this.target, pathToParent, 1);
    }

    private JsonNode getNode(JsonNode ret, List<String> path, int pos) {
        if (pos >= path.size()) {
            return ret;
        }
        String key = path.get(pos);
        if (ret.isArray()) {
            int keyInt = Integer.parseInt(key.replaceAll("\"", ""));
            JsonNode element = ret.get(keyInt);
            if (element == null) {
                return null;
            }
            return this.getNode(ret.get(keyInt), path, ++pos);
        }
        if (ret.isObject()) {
            if (ret.has(key)) {
                return this.getNode(ret.get(key), path, ++pos);
            }
            return null;
        }
        return ret;
    }

    private int arrayIndex(String s, int max) {
        int index = Integer.parseInt(s);
        if (index < 0) {
            throw new JsonPatchApplicationException("index Out of bound, index is negative");
        }
        if (index > max) {
            throw new JsonPatchApplicationException("index Out of bound, index is greater than " + max);
        }
        return index;
    }
}

