/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;

public final class JUnitTestCaseCheck
extends Check {
    private static final String SET_UP_METHOD_NAME = "setUp";
    private static final String TEAR_DOWN_METHOD_NAME = "tearDown";
    private static final String SUITE_METHOD_NAME = "suite";

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 9: {
                this.visitMethodDef(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitMethodDef(DetailAST aAST) {
        String name = aAST.findFirstToken(58).getText();
        if (name.equalsIgnoreCase(SET_UP_METHOD_NAME)) {
            this.checkSetUpTearDownMethod(aAST, name, SET_UP_METHOD_NAME);
        } else if (name.equalsIgnoreCase(TEAR_DOWN_METHOD_NAME)) {
            this.checkSetUpTearDownMethod(aAST, name, TEAR_DOWN_METHOD_NAME);
        } else if (name.equalsIgnoreCase(SUITE_METHOD_NAME)) {
            this.checkSuiteMethod(aAST, name);
        }
    }

    private void checkSuiteMethod(DetailAST aAST, String aActualName) {
        DetailAST typeAST;
        if (!aActualName.equals(SUITE_METHOD_NAME)) {
            this.log(aAST, "junit.method.name", SUITE_METHOD_NAME);
        }
        if (!this.isPublicAndStatic(aAST)) {
            this.log(aAST, "junit.method.public.and.static", SUITE_METHOD_NAME);
        }
        boolean isArray = (typeAST = aAST.findFirstToken(13)).findFirstToken(17) != null;
        String type = CheckUtils.createFullType(typeAST).getText();
        if (isArray || !"Test".equals(type) && !"junit.framework.Test".equals(type)) {
            this.log(aAST, "junit.method.return.type", SUITE_METHOD_NAME, "junit.framework.Test");
        }
        this.checkParameters(aAST, SUITE_METHOD_NAME);
    }

    private void checkSetUpTearDownMethod(DetailAST aAST, String aActualName, String aExpectedName) {
        if (!aActualName.equals(aExpectedName)) {
            this.log(aAST, "junit.method.name", aActualName, aExpectedName);
        }
        if (!this.isPublicOrProtected(aAST)) {
            this.log(aAST, "junit.method.protected.or.public", aExpectedName);
        }
        if (this.isStatic(aAST)) {
            this.log(aAST, "junit.method.static", aExpectedName);
        }
        this.checkReturnValue(aAST, aActualName);
        this.checkParameters(aAST, aActualName);
    }

    private void checkReturnValue(DetailAST aAST, String aName) {
        DetailAST returnValueAST = aAST.findFirstToken(13);
        if (returnValueAST.findFirstToken(49) == null) {
            this.log(aAST, "junit.method.return.type", aName, "void");
        }
    }

    private void checkParameters(DetailAST aAST, String aName) {
        DetailAST parametersAST = aAST.findFirstToken(20);
        if (parametersAST.getChildCount() != 0) {
            this.log(aAST, "junit.method.parameters", aName);
        }
    }

    private boolean isPublicOrProtected(DetailAST aAST) {
        DetailAST modifiersAST = aAST.findFirstToken(5);
        DetailAST publicAST = modifiersAST.findFirstToken(62);
        DetailAST protectedAST = modifiersAST.findFirstToken(63);
        return publicAST != null || protectedAST != null;
    }

    private boolean isPublicAndStatic(DetailAST aAST) {
        DetailAST modifiersAST = aAST.findFirstToken(5);
        DetailAST publicAST = modifiersAST.findFirstToken(62);
        DetailAST staticAST = modifiersAST.findFirstToken(64);
        return publicAST != null && staticAST != null;
    }

    private boolean isStatic(DetailAST aAST) {
        DetailAST modifiersAST = aAST.findFirstToken(5);
        DetailAST staticAST = modifiersAST.findFirstToken(64);
        return staticAST != null;
    }
}

