/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

public class BugAccumulator {
    private final BugReporter reporter;
    private final boolean performAccumulation;
    private final Map<BugInstance, Data> map = new HashMap<BugInstance, Data>();
    private final HashMap<String, BugInstance> hashes = new HashMap();
    private BugInstance lastBug;
    private SourceLineAnnotation lastSourceLine;

    public BugAccumulator(BugReporter reporter) {
        this.reporter = reporter;
        this.performAccumulation = AnalysisContext.currentAnalysisContext().getBoolProperty(7);
    }

    @CheckForNull
    public SourceLineAnnotation getLastBugLocation() {
        return this.lastSourceLine;
    }

    public void forgetLastBug() {
        Data d = this.map.get(this.lastBug);
        if (d != null) {
            d.allSource.remove(this.lastSourceLine);
            if (d.allSource.isEmpty()) {
                this.map.remove(this.lastBug);
                this.hashes.remove(this.lastBug.getInstanceHash());
            }
        }
        this.lastBug = null;
        this.lastSourceLine = null;
    }

    public void accumulateBug(BugInstance bug, SourceLineAnnotation sourceLine) {
        if (sourceLine == null) {
            throw new NullPointerException("Missing source line");
        }
        int priority = bug.getPriority();
        if (!this.performAccumulation) {
            bug.addSourceLine(sourceLine);
        } else {
            bug.setPriority(2);
        }
        this.lastBug = bug;
        this.lastSourceLine = sourceLine;
        Data d = this.map.get(bug);
        if (d == null) {
            String hash = bug.getInstanceHash();
            BugInstance conflictingBug = this.hashes.get(hash);
            if (conflictingBug != null) {
                if (conflictingBug.getPriority() <= priority) {
                    return;
                }
                this.map.remove(conflictingBug);
            }
            d = new Data(priority, sourceLine);
            this.map.put(bug, d);
            this.hashes.put(hash, bug);
        } else if (d.priority > priority) {
            if (d.priority >= 3) {
                this.reportBug(bug, d);
                d.allSource.clear();
            }
            d.priority = priority;
            d.primarySource = sourceLine;
        } else if (priority >= 3 && priority > d.priority) {
            bug.setPriority(priority);
            this.reporter.reportBug(bug);
            return;
        }
        d.allSource.add(sourceLine);
    }

    public void accumulateBug(BugInstance bug, BytecodeScanningDetector visitor) {
        SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction(visitor);
        this.accumulateBug(bug, source);
    }

    public Iterable<? extends BugInstance> uniqueBugs() {
        return this.map.keySet();
    }

    public Iterable<? extends SourceLineAnnotation> locations(BugInstance bug) {
        return this.map.get((Object)bug).allSource;
    }

    public void reportAccumulatedBugs() {
        for (Map.Entry<BugInstance, Data> e : this.map.entrySet()) {
            BugInstance bug = e.getKey();
            Data d = e.getValue();
            this.reportBug(bug, d);
        }
        this.clearBugs();
    }

    public void reportBug(BugInstance bug, Data d) {
        bug.setPriority(d.priority);
        bug.addSourceLine(d.primarySource);
        HashSet<Integer> lines = new HashSet<Integer>();
        lines.add(d.primarySource.getStartLine());
        d.allSource.remove(d.primarySource);
        for (SourceLineAnnotation source : d.allSource) {
            if (!lines.add(source.getStartLine())) continue;
            bug.addSourceLine(source);
            bug.describe("SOURCE_LINE_ANOTHER_INSTANCE");
        }
        this.reporter.reportBug(bug);
    }

    public void clearBugs() {
        this.map.clear();
        this.hashes.clear();
        this.lastBug = null;
        this.lastSourceLine = null;
    }

    public void accumulateBug(BugInstance bug, ClassContext classContext, Method method, Location location) {
        this.accumulateBug(bug, SourceLineAnnotation.fromVisitedInstruction(classContext, method, location));
    }

    public void accumulateBug(BugInstance bug, ClassContext classContext, MethodGen methodGen, String sourceFile, Location location) {
        this.accumulateBug(bug, SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, location.getHandle()));
    }

    static class Data {
        int priority;
        SourceLineAnnotation primarySource;
        LinkedHashSet<SourceLineAnnotation> allSource = new LinkedHashSet();

        public Data(int priority, SourceLineAnnotation primarySource) {
            this.priority = priority;
            this.primarySource = primarySource;
        }
    }
}

