/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;

public class Footprint {
    private static final int NOCLASSDEF_ERROR = -9;
    private static final int CLASSCAST_ERROR = -8;
    private static final int ERROR_ERROR = -7;
    private static final int RUNTIME_EXCEPTION = -6;
    private long cpuTime = -1L;
    private long clockTime = -1L;
    private long peakMem = -1L;
    private long collectionTime = -1L;

    public Footprint() {
        this.pullData();
    }

    public Footprint(Footprint base) {
        this.pullData();
        if (this.cpuTime >= 0L) {
            long l = this.cpuTime = base.cpuTime >= 0L ? this.cpuTime - base.cpuTime : base.cpuTime;
        }
        if (this.clockTime >= 0L) {
            long l = this.clockTime = base.clockTime >= 0L ? this.clockTime - base.clockTime : base.clockTime;
        }
        if (this.collectionTime >= 0L) {
            this.collectionTime = base.collectionTime >= 0L ? this.collectionTime - base.collectionTime : base.collectionTime;
        }
    }

    private void pullData() {
        try {
            this.cpuTime = new OperatingSystemBeanWrapper().getProcessCpuTime();
        }
        catch (NoClassDefFoundError ncdfe) {
            this.cpuTime = -9L;
        }
        catch (ClassCastException cce) {
            this.cpuTime = -8L;
        }
        catch (Error error) {
            this.cpuTime = -7L;
        }
        catch (RuntimeException error) {
            this.cpuTime = -6L;
        }
        this.clockTime = System.currentTimeMillis();
        try {
            this.peakMem = new MemoryBeanWrapper().getPeakUsage();
        }
        catch (NoClassDefFoundError ncdfe) {
            this.peakMem = -9L;
        }
        catch (Error ncdfe) {
            this.peakMem = -8L;
        }
        catch (RuntimeException ncdfe) {
            this.peakMem = -6L;
        }
        try {
            this.collectionTime = new CollectionBeanWrapper().getCollectionTime();
        }
        catch (NoClassDefFoundError ncdfe) {
            this.collectionTime = -9L;
        }
        catch (Error ncdfe) {
            this.peakMem = -7L;
        }
        catch (RuntimeException ncdfe) {
            this.collectionTime = -6L;
        }
    }

    public long getCpuTime() {
        return this.cpuTime;
    }

    public long getClockTime() {
        return this.clockTime;
    }

    public long getPeakMemory() {
        return this.peakMem;
    }

    public long getCollectionTime() {
        return this.collectionTime;
    }

    public String toString() {
        return "cpuTime=" + this.cpuTime + ", clockTime=" + this.clockTime + ", peakMemory=" + this.peakMem;
    }

    public static void main(String[] argv) {
        System.out.println(new Footprint());
    }

    public static class OperatingSystemBeanWrapper {
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        OperatingSystemMXBean sunBean = (OperatingSystemMXBean)this.osBean;

        public long getProcessCpuTime() {
            return this.sunBean.getProcessCpuTime();
        }
    }

    public static class MemoryBeanWrapper {
        List<MemoryPoolMXBean> mlist = ManagementFactory.getMemoryPoolMXBeans();

        public long getPeakUsage() {
            long sum = 0L;
            for (MemoryPoolMXBean mpBean : this.mlist) {
                try {
                    MemoryUsage memUsage = mpBean.getPeakUsage();
                    if (memUsage == null) continue;
                    sum += memUsage.getUsed();
                }
                catch (RuntimeException runtimeException) {}
            }
            return sum;
        }
    }

    public static class CollectionBeanWrapper {
        List<GarbageCollectorMXBean> clist = ManagementFactory.getGarbageCollectorMXBeans();

        public long getCollectionTime() {
            long sum = 0L;
            for (GarbageCollectorMXBean gcBean : this.clist) {
                sum += gcBean.getCollectionTime();
            }
            return sum;
        }
    }
}

