/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.asm.FBClassReader;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class SelfMethodCalls {
    private static boolean interestingSignature(String signature) {
        return !"()V".equals(signature);
    }

    public static <T> MultiMap<T, T> getSelfCalls(final ClassDescriptor classDescriptor, final Map<String, T> methods) {
        FBClassReader reader;
        final MultiMap map = new MultiMap(HashSet.class);
        try {
            reader = Global.getAnalysisCache().getClassAnalysis(FBClassReader.class, classDescriptor);
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error finding self method calls for " + classDescriptor, e);
            return map;
        }
        reader.accept(new ClassVisitor(589824){

            public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
                return new MethodVisitor(589824){

                    public void visitMethodInsn(int opcode, String owner, String name2, String desc2, boolean itf) {
                        if (owner.equals(classDescriptor.getClassName()) && SelfMethodCalls.interestingSignature(desc2)) {
                            Object from = methods.get(name + desc + ((access & 8) != 0));
                            Object to = methods.get(name2 + desc2 + (opcode == 184));
                            map.add(from, to);
                        }
                    }
                };
            }
        }, 6);
        return map;
    }

    public SelfMethodCalls(ClassReader classReader) {
    }
}

