/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class DontAssertInstanceofInTests
extends OpcodeStackDetector {
    private boolean isTest;
    private BugInstance currBug = null;
    BugReporter bugReporter;

    public DontAssertInstanceofInTests(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitMethod(Method obj) {
        this.isTest = false;
        for (AnnotationEntry entry : obj.getAnnotationEntries()) {
            String entryType = entry.getAnnotationType();
            this.isTest |= "Lorg/junit/Test;".equals(entryType);
        }
    }

    @Override
    public boolean shouldVisitCode(Code obj) {
        return this.isTest;
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 193: {
                this.currBug = new BugInstance(this, "JUA_DONT_ASSERT_INSTANCEOF_IN_TESTS", 2);
                String operand = this.getDottedClassConstantOperand();
                this.currBug.addTypeOfNamedClass(operand);
                break;
            }
            case 184: {
                if (this.getPrevOpcode(1) != 193) break;
                String ciOp = this.getClassConstantOperand();
                String ncOp = this.getNameConstantOperand();
                if (!"org/junit/Assert".equals(ciOp) || !"assertTrue".equals(ncOp)) break;
                this.currBug.addClassAndMethod(this).addSourceLine(this);
                this.bugReporter.reportBug(this.currBug);
            }
        }
    }
}

