/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import org.apache.bcel.classfile.CodeException;

public class DontCatchNullPointerException
extends BytecodeScanningDetector {
    private final BugReporter reporter;
    @DottedClassName
    private static final String NULLPOINTER_EXCEPTION_FQCN = "java.lang.NullPointerException";

    public DontCatchNullPointerException(BugReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void visit(CodeException exc) {
        int type = exc.getCatchType();
        if (type == 0) {
            return;
        }
        String name = this.getConstantPool().constantToString(this.getConstantPool().getConstant(type));
        if (name.equals(NULLPOINTER_EXCEPTION_FQCN)) {
            BugInstance bug = new BugInstance(this, "DCN_NULLPOINTER_EXCEPTION", 2);
            bug.addClassAndMethod(this);
            bug.addSourceLine(this.getClassContext(), this, exc.getHandlerPC());
            this.reporter.reportBug(bug);
        }
    }
}

