/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.JavaClass;

public class FindBadEndOfStreamCheck
extends OpcodeStackDetector {
    private final BugAccumulator bugAccumulator;
    private OpcodeStack.Item itemUnderCast;
    private OpcodeStack.Item castedItem;
    private XMethod source;

    public FindBadEndOfStreamCheck(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        Object value;
        OpcodeStack.Item leftItem;
        OpcodeStack.Item rightItem;
        OpcodeStack.Item item;
        this.itemUnderCast = null;
        if (seen == 145 || seen == 146) {
            item = this.stack.getStackItem(0);
            XMethod method = item.getReturnValueOf();
            if (method == null || !this.isFileRead(method)) {
                return;
            }
            this.itemUnderCast = item;
            this.source = method;
        }
        if ((seen == 159 || seen == 160) && this.castedItem != null) {
            rightItem = this.stack.getStackItem(0);
            leftItem = this.stack.getStackItem(1);
            value = null;
            if (leftItem.equals(this.castedItem)) {
                value = rightItem.getConstant();
            } else if (rightItem.equals(this.castedItem)) {
                value = leftItem.getConstant();
            }
            if (value instanceof Integer && (Integer)value == -1) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "EOS_BAD_END_OF_STREAM_CHECK", 2).addClassAndMethod(this).addCalledMethod(this.source).addString(this.castedItem.getSignature().equals("B") ? "byte" : "char").addInt(-1), this);
            }
        }
        if ((seen == 156 || seen == 155) && this.castedItem != null && (item = this.stack.getStackItem(0)).equals(this.castedItem)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EOS_BAD_END_OF_STREAM_CHECK", 2).addClassAndMethod(this).addCalledMethod(this.source).addString(this.castedItem.getSignature().equals("B") ? "byte" : "char").addInt(0), this);
        }
        if ((seen == 164 || seen == 163) && this.castedItem != null) {
            rightItem = this.stack.getStackItem(0);
            leftItem = this.stack.getStackItem(1);
            value = null;
            if (rightItem.equals(this.castedItem)) {
                value = leftItem.getConstant();
            }
            if (value instanceof Integer && (Integer)value == 0) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "EOS_BAD_END_OF_STREAM_CHECK", 2).addClassAndMethod(this).addCalledMethod(this.source).addString(this.castedItem.getSignature().equals("B") ? "byte" : "char").addInt(0), this);
            }
        }
    }

    @Override
    public void afterOpcode(int seen) {
        super.afterOpcode(seen);
        if ((seen == 145 || seen == 146) && this.itemUnderCast != null) {
            this.castedItem = this.stack.getStackItem(0);
        }
    }

    private boolean isFileRead(XMethod method) {
        String classSig = method.getClassDescriptor().getSignature();
        return method != null && "read".equals(method.getName()) && ("Ljava/io/FileInputStream;".equals(classSig) || "Ljava/io/FileReader;".equals(classSig));
    }
}

