/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.bcel.classfile.Code;

public class FindFloatEquality
extends OpcodeStackDetector
implements StatelessDetector {
    private static final int SAW_NOTHING = 0;
    private static final int SAW_COMP = 1;
    private int priority;
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private int state;
    Collection<SourceLineAnnotation> found = new LinkedList<SourceLineAnnotation>();

    public FindFloatEquality(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code obj) {
        this.found.clear();
        this.priority = 3;
        this.state = 0;
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
        if (!this.found.isEmpty()) {
            BugInstance bug = new BugInstance(this, "FE_FLOATING_POINT_EQUALITY", this.priority).addClassAndMethod(this);
            boolean first = true;
            for (SourceLineAnnotation s : this.found) {
                bug.add(s);
                if (first) {
                    first = false;
                    continue;
                }
                bug.describe("SOURCE_LINE_ANOTHER_INSTANCE");
            }
            this.bugReporter.reportBug(bug);
            this.found.clear();
        }
    }

    public boolean isZero(Number n) {
        if (n == null) {
            return false;
        }
        double v = n.doubleValue();
        return v == 0.0;
    }

    public boolean okValueToCompareAgainst(Number n) {
        if (n == null) {
            return false;
        }
        double v = n.doubleValue();
        if (Double.isInfinite(v) || Double.isNaN(v)) {
            return true;
        }
        return (v -= Math.floor(v)) == 0.0;
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                if (this.stack.getStackDepth() < 2) break;
                OpcodeStack.Item first = this.stack.getStackItem(0);
                OpcodeStack.Item second = this.stack.getStackItem(1);
                if (first.getRegisterNumber() == second.getRegisterNumber() && first.getRegisterNumber() != -1 || first.isInitialParameter() && second.isInitialParameter() || FindFloatEquality.sameField(first, second)) break;
                Number n1 = (Number)first.getConstant();
                Number n2 = (Number)second.getConstant();
                if (n1 != null && Double.isNaN(n1.doubleValue()) || n2 != null && Double.isNaN(n2.doubleValue())) {
                    BugInstance bug = new BugInstance(this, "FE_TEST_IF_EQUAL_TO_NOT_A_NUMBER", 1).addClassAndMethod(this);
                    this.bugAccumulator.accumulateBug(bug, this);
                    this.state = 0;
                    break;
                }
                if (first.getSpecialKind() == 15 && !this.isZero(n2) || second.getSpecialKind() == 15 && !this.isZero(n1) || first.getSpecialKind() == 7 && !this.okValueToCompareAgainst(n2) || second.getSpecialKind() == 7 && !this.okValueToCompareAgainst(n1)) {
                    if (this.priority != 1) {
                        this.found.clear();
                    }
                    this.priority = 1;
                    this.state = 1;
                    break;
                }
                if (this.priority == 1 || n1 != null && n2 != null || this.okValueToCompareAgainst(n1) || this.okValueToCompareAgainst(n2)) break;
                if (n1 != null && !second.isInitialParameter() || n2 != null && !first.isInitialParameter()) {
                    if (this.priority == 3) {
                        this.found.clear();
                    }
                    this.priority = 2;
                } else if (this.priority == 2) break;
                this.state = 1;
                break;
            }
            case 153: 
            case 154: {
                SourceLineAnnotation sourceLineAnnotation;
                if (this.state == 1 && (sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, this.getPC())) != null) {
                    this.found.add(sourceLineAnnotation);
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }

    static boolean sameField(OpcodeStack.Item i1, OpcodeStack.Item i2) {
        return Objects.equals(i1.getXField(), i2.getXField()) && i1.getFieldLoadedFromRegister() == i2.getFieldLoadedFromRegister();
    }
}

