/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;

public class FindLocalSelfAssignment2
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private int previousLoadOf = -1;
    private int previousGotoTarget;
    private int gotoCount;
    private final BitSet previousStores = new BitSet();

    public FindLocalSelfAssignment2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code obj) {
        this.previousLoadOf = -1;
        this.previousGotoTarget = -1;
        this.gotoCount = 0;
        this.previousStores.clear();
        super.visit(obj);
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 167) {
            this.previousGotoTarget = this.getBranchTarget();
            ++this.gotoCount;
            if (this.previousGotoTarget < this.getPC()) {
                this.previousLoadOf = -1;
            }
        } else if (this.isRegisterLoad()) {
            this.previousLoadOf = this.getRegisterOperand();
        } else {
            if (this.isRegisterStore()) {
                if (this.previousLoadOf == this.getRegisterOperand() && this.gotoCount < 2 && this.getPC() != this.previousGotoTarget) {
                    int priority = 2;
                    String methodName = this.getMethodName();
                    if ("<init>".equals(methodName) || methodName.startsWith("set") && this.getCode().getCode().length <= 5 || !this.previousStores.get(this.getRegisterOperand())) {
                        priority = 1;
                    }
                    this.previousStores.set(this.getRegisterOperand());
                    XClass c = this.getXClass();
                    LocalVariableAnnotation local = LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), this.getRegisterOperand(), this.getPC(), this.getPC());
                    if ("?".equals(local.getName())) {
                        ++priority;
                    } else {
                        for (XField xField : c.getXFields()) {
                            if (!xField.getName().equals(local.getName()) || !xField.isStatic() && this.getMethod().isStatic()) continue;
                            this.bugReporter.reportBug(new BugInstance(this, "SA_LOCAL_SELF_ASSIGNMENT_INSTEAD_OF_FIELD", priority).addClassAndMethod(this).add(local).addField(xField).describe("FIELD_DID_YOU_MEAN").addSourceLine(this));
                            return;
                        }
                    }
                    this.bugReporter.reportBug(new BugInstance(this, "SA_LOCAL_SELF_ASSIGNMENT", priority).addClassAndMethod(this).add(local).addSourceLine(this));
                } else {
                    this.previousStores.set(this.getRegisterOperand());
                }
            }
            this.previousLoadOf = -1;
            this.gotoCount = 0;
        }
    }
}

