/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.util.BootstrapMethodsUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Method;

public class FindPotentialSecurityCheckBasedOnUntrustedSource
extends OpcodeStackDetector {
    private static final Pattern NESTED_CLASS_VARIABLE_NAME_PATTERN = Pattern.compile("val\\$.*");
    private Map<XMethod, Set<CalleeInfo>> nonFinalMethodsCalledOnParam = new HashMap<XMethod, Set<CalleeInfo>>();
    private Map<XMethod, Set<CallerInfo>> methodsCalledInsidePrivilegedAction = new HashMap<XMethod, Set<CallerInfo>>();
    private Map<OpcodeStack.Item, LambdaInfo> lambdaFunctions = new HashMap<OpcodeStack.Item, LambdaInfo>();
    private Map<Method, LambdaCallInfo> lambdaCalledInDoPrivileged = new HashMap<Method, LambdaCallInfo>();
    private Stack<String> parameterNameStack = new Stack();
    private LambdaInfo currentLambda = null;
    private boolean isDoPrivileged = false;
    private boolean isDoPrivilegedRun = false;
    private boolean isLambdaCalledInDoPrivileged = false;
    private final BugAccumulator bugAccumulator;

    public FindPotentialSecurityCheckBasedOnUntrustedSource(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(JavaClass obj) {
        this.nonFinalMethodsCalledOnParam.clear();
        this.isDoPrivileged = Subtypes2.instanceOf(this.getDottedClassName(), "java.security.PrivilegedAction") || Subtypes2.instanceOf(this.getDottedClassName(), "java.security.PrivilegedExceptionAction");
    }

    @Override
    public void visit(Method obj) {
        this.isDoPrivilegedRun = this.isDoPrivileged && "run".equals(this.getMethodName()) && this.getMethodSig().startsWith("()");
        this.isLambdaCalledInDoPrivileged = this.lambdaCalledInDoPrivileged.containsKey(obj);
    }

    @Override
    public void visit(Code obj) {
        if (!(this.isDoPrivilegedRun || this.isLambdaCalledInDoPrivileged || this.getThisClass().isPublic() && this.getMethod().isPublic())) {
            return;
        }
        super.visit(obj);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        this.currentLambda = null;
        if (seen == 186) {
            ConstantInvokeDynamic constDyn = (ConstantInvokeDynamic)this.getConstantRefOperand();
            for (Attribute attr : this.getThisClass().getAttributes()) {
                Optional<Method> method;
                if (!(attr instanceof BootstrapMethods) || !(method = BootstrapMethodsUtil.getMethodFromBootstrap((BootstrapMethods)attr, constDyn.getBootstrapMethodAttrIndex(), this.getConstantPool(), this.getThisClass())).isPresent()) continue;
                String[] paramNames = this.getParamNames();
                this.currentLambda = new LambdaInfo(method.get(), paramNames);
                break;
            }
        } else if (seen == 182 && this.getXClassOperand() != null && this.getXMethodOperand() != null) {
            if (this.getXMethodOperand().getSignature().endsWith("V")) {
                return;
            }
            OpcodeStack.Item object = this.stack.getStackItem(0);
            if (this.isDoPrivilegedRun) {
                if (!this.getXClassOperand().isFinal() && !this.getXMethodOperand().isFinal() && object.isInitialParameter() && this.isNestingMethodLocalVariable(object)) {
                    this.addToMethodsCalledInsidePrivilegedAction(this.getXMethodOperand(), object);
                }
                return;
            }
            if (this.isLambdaCalledInDoPrivileged) {
                CalleeInfo callBefore;
                LambdaCallInfo lambdaCall = this.lambdaCalledInDoPrivileged.get(this.getMethod());
                if (!this.getXClassOperand().isFinal() && !this.getXMethodOperand().isFinal() && object.isInitialParameter() && this.isLambdaNestingMethodLocalVariable(object, lambdaCall) && (callBefore = this.lookForCalledOutside(lambdaCall.callerClass, lambdaCall.callerMethod, this.getXClassOperand(), this.getXMethodOperand(), lambdaCall.argumentNames[object.getRegisterNumber()])) != null) {
                    this.reportBug(lambdaCall.callerClass, lambdaCall.callerMethod, lambdaCall.srcLine, callBefore, SourceLineAnnotation.fromVisitedInstruction(this));
                }
                return;
            }
            if (this.getXClass().isPublic() && this.getXMethod().isPublic() && !this.getXClassOperand().isFinal() && !this.getXMethodOperand().isFinal() && object.isInitialParameter() && object.getXField() == null && !this.parameterNameStack.empty() && this.parameterNameStack.peek() != null) {
                this.addToNonFinalMethodsCalledOnParam(this.getClassDescriptorOperand(), this.getXMethodOperand(), object);
            }
        } else if (seen == 184 && this.getXMethodOperand() != null && "doPrivileged".equals(this.getXMethodOperand().getName())) {
            OpcodeStack.Item action = this.stack.getStackItem(0);
            CallPair callPair = this.lookForCalledOutsideAndInside(action);
            if (callPair != null) {
                this.reportBug(callPair);
                return;
            }
            LambdaInfo lambda = this.lambdaFunctions.get(action);
            if (lambda != null) {
                this.lambdaCalledInDoPrivileged.put(lambda.lambdaMethod, new LambdaCallInfo(this.getThisClass(), this.getXMethod(), SourceLineAnnotation.fromVisitedInstruction(this), lambda.argumentNames));
            }
        }
    }

    private String[] getParamNames() {
        String[] names = new String[this.stack.getStackDepth()];
        for (int i = 0; i < this.stack.getStackDepth() && i < this.parameterNameStack.size(); ++i) {
            OpcodeStack.Item param = this.stack.getStackItem(i);
            if (!param.isInitialParameter() || param.getXField() != null) continue;
            names[i] = this.parameterNameStack.pop();
        }
        return names;
    }

    private boolean isNestingMethodLocalVariable(OpcodeStack.Item object) {
        XField field = object.getXField();
        if (field == null) {
            return false;
        }
        return NESTED_CLASS_VARIABLE_NAME_PATTERN.matcher(field.getName()).matches();
    }

    private boolean isLambdaNestingMethodLocalVariable(OpcodeStack.Item object, LambdaCallInfo lambdaCall) {
        if (object.getRegisterNumber() < 0) {
            return false;
        }
        return object.getRegisterNumber() <= lambdaCall.argumentNames.length && lambdaCall.argumentNames[object.getRegisterNumber()] != null;
    }

    private void addToMethodsCalledInsidePrivilegedAction(XMethod calledMethod, OpcodeStack.Item object) {
        Set objects = this.methodsCalledInsidePrivilegedAction.computeIfAbsent(calledMethod, k -> new HashSet());
        objects.add(new CallerInfo(object, this.getThisClass(), SourceLineAnnotation.fromVisitedInstruction(this)));
    }

    private void addToNonFinalMethodsCalledOnParam(ClassDescriptor calledClass, XMethod calledMethod, OpcodeStack.Item object) {
        Set objects = this.nonFinalMethodsCalledOnParam.computeIfAbsent(this.getXMethod(), k -> new HashSet());
        objects.add(new CalleeInfo(calledClass, calledMethod, this.parameterNameStack.peek(), SourceLineAnnotation.fromVisitedInstruction(this)));
    }

    private CallPair lookForCalledOutsideAndInside(OpcodeStack.Item action) {
        Set<CalleeInfo> callees = this.nonFinalMethodsCalledOnParam.get(this.getXMethod());
        if (callees == null) {
            return null;
        }
        for (CalleeInfo calleeInfo : callees) {
            CallerInfo inside = this.getCalledInside(action, calleeInfo);
            if (inside == null) continue;
            return new CallPair(calleeInfo, inside);
        }
        return null;
    }

    private CallerInfo getCalledInside(OpcodeStack.Item action, CalleeInfo calleeInfo) {
        Set<CallerInfo> callers = this.methodsCalledInsidePrivilegedAction.get(calleeInfo.calledMethod);
        if (callers == null) {
            return null;
        }
        for (CallerInfo callerInfo : callers) {
            if (!this.isTheSame(callerInfo, calleeInfo, action)) continue;
            return callerInfo;
        }
        return null;
    }

    private CalleeInfo lookForCalledOutside(JavaClass callerClass, XMethod callerMethod, XClass calledClass, XMethod calledMethod, String argumentName) {
        Set<CalleeInfo> callees = this.nonFinalMethodsCalledOnParam.get(callerMethod);
        if (callees == null) {
            return null;
        }
        for (CalleeInfo calleeInfo : callees) {
            if (calleeInfo.calledMethod != calledMethod || !calleeInfo.calledOnName.equals(argumentName)) continue;
            return calleeInfo;
        }
        return null;
    }

    private boolean isTheSame(CallerInfo inside, CalleeInfo outside, OpcodeStack.Item action) {
        XField field = inside.calledOn.getXField();
        if (field == null) {
            return false;
        }
        try {
            return action.getJavaClass().equals((Object)inside.callerClass) && field.getName().equals("val$" + outside.calledOnName);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    private void reportBug(CallPair callPair) {
        this.bugAccumulator.accumulateBug(new BugInstance(this, "USC_POTENTIAL_SECURITY_CHECK_BASED_ON_UNTRUSTED_SOURCE", 2).addClassAndMethod(this).addSourceLine(this).addClass(callPair.outside.calledClass.getClassName()).addCalledMethod(callPair.outside.calledClass.getClassName(), callPair.outside.calledMethod.getName(), callPair.outside.calledMethod.getSignature(), callPair.outside.calledMethod.isStatic()).addSourceLine(callPair.outside.srcLine).addSourceLine(callPair.inside.srcLine), this);
    }

    private void reportBug(JavaClass cls, XMethod method, SourceLineAnnotation srcLine, CalleeInfo calleInfo, SourceLineAnnotation insideSrcLine) {
        this.bugAccumulator.accumulateBug(new BugInstance(this, "USC_POTENTIAL_SECURITY_CHECK_BASED_ON_UNTRUSTED_SOURCE", 2).addClass(cls).addMethod(method).addSourceLine(srcLine).addClass(calleInfo.calledClass.getClassName()).addCalledMethod(calleInfo.calledClass.getClassName(), calleInfo.calledMethod.getName(), calleInfo.calledMethod.getSignature(), calleInfo.calledMethod.isStatic()).addSourceLine(calleInfo.srcLine).addSourceLine(insideSrcLine), this);
    }

    @Override
    public void afterOpcode(int seen) {
        super.afterOpcode(seen);
        if (this.currentLambda != null && this.stack.getStackDepth() > 0) {
            this.lambdaFunctions.put(this.stack.getStackItem(0), this.currentLambda);
            return;
        }
        if (seen != 25 && seen != 42 && seen != 43 && seen != 44 && seen != 45) {
            this.parameterNameStack.clear();
        }
        LocalVariable localVar = null;
        if (this.getMethod().getLocalVariableTable() != null) {
            if (seen == 43 && this.getXMethod().getNumParams() >= 1) {
                localVar = this.getMethod().getLocalVariableTable().getLocalVariable(1, this.getPC());
            } else if (seen == 44 && this.getXMethod().getNumParams() >= 2) {
                localVar = this.getMethod().getLocalVariableTable().getLocalVariable(2, this.getPC());
            } else if (seen == 45 && this.getXMethod().getNumParams() >= 3) {
                localVar = this.getMethod().getLocalVariableTable().getLocalVariable(3, this.getPC());
            } else if (seen == 25 && this.getXMethod().getNumParams() >= this.getRegisterOperand()) {
                localVar = this.getMethod().getLocalVariableTable().getLocalVariable(this.getRegisterOperand(), this.getPC());
            }
        }
        if (localVar == null) {
            this.parameterNameStack.push(null);
            return;
        }
        this.parameterNameStack.push(localVar.getName());
    }

    private static class LambdaInfo {
        private final Method lambdaMethod;
        private final String[] argumentNames;

        LambdaInfo(Method method, String[] argNames) {
            this.lambdaMethod = method;
            this.argumentNames = argNames;
        }
    }

    private static class LambdaCallInfo {
        private final JavaClass callerClass;
        private final XMethod callerMethod;
        private final SourceLineAnnotation srcLine;
        private final String[] argumentNames;

        LambdaCallInfo(JavaClass cls, XMethod met, SourceLineAnnotation line, String[] argNames) {
            this.callerClass = cls;
            this.callerMethod = met;
            this.srcLine = line;
            this.argumentNames = argNames;
        }
    }

    private static class CalleeInfo {
        private final ClassDescriptor calledClass;
        private final XMethod calledMethod;
        private final String calledOnName;
        private final SourceLineAnnotation srcLine;

        CalleeInfo(ClassDescriptor cls, XMethod called, String name, SourceLineAnnotation line) {
            this.calledClass = cls;
            this.calledMethod = called;
            this.calledOnName = name;
            this.srcLine = line;
        }
    }

    private static class CallPair {
        private final CalleeInfo outside;
        private final CallerInfo inside;

        CallPair(CalleeInfo out, CallerInfo in) {
            this.outside = out;
            this.inside = in;
        }
    }

    private static class CallerInfo {
        private final OpcodeStack.Item calledOn;
        private final JavaClass callerClass;
        private final SourceLineAnnotation srcLine;

        CallerInfo(OpcodeStack.Item obj, JavaClass cls, SourceLineAnnotation line) {
            this.calledOn = obj;
            this.callerClass = cls;
            this.srcLine = line;
        }
    }
}

