/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassSummary;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.IncompatibleTypes;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.TestCaseDetector;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.ExtendedTypes;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.StandardTypeMerger;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.type.TypeFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.type.TypeMerger;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.detect.RefComparisonWarningProperty;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindRefComparison
implements Detector,
ExtendedTypes {
    private static final boolean DEBUG = SystemProperties.getBoolean("frc.debug");
    private static final boolean REPORT_ALL_REF_COMPARISONS = true;
    private static final int BASE_ES_PRIORITY = SystemProperties.getInt("es.basePriority", 2);
    @StaticConstant
    private static final HashSet<String> DEFAULT_SUSPICIOUS_SET = new HashSet();
    private static final BitSet invokeInstanceSet;
    private static final BitSet prescreenSet;
    private static final byte T_DYNAMIC_STRING = 100;
    private static final byte T_STATIC_STRING = 101;
    private static final byte T_PARAMETER_STRING = 102;
    private static final String STRING_SIGNATURE = "Ljava/lang/String;";
    private static final Type dynamicStringTypeInstance;
    private static final Type staticStringTypeInstance;
    private static final Type emptyStringTypeInstance;
    private static final Type parameterStringTypeInstance;
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private ClassContext classContext;
    private final Set<String> suspiciousSet;
    private final boolean testingEnabled;
    private Map<String, Integer> comparedForEqualityInThisMethod;

    public FindRefComparison(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.suspiciousSet = new HashSet<String>(DEFAULT_SUSPICIOUS_SET);
        String extraSuspiciousTypes = SystemProperties.getProperty("frc.suspicious");
        if (extraSuspiciousTypes != null) {
            StringTokenizer tok = new StringTokenizer(extraSuspiciousTypes, ",");
            while (tok.hasMoreTokens()) {
                this.suspiciousSet.add(tok.nextToken());
            }
        }
        this.testingEnabled = SystemProperties.getBoolean("report_TESTING_pattern_in_standard_detectors");
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        this.classContext = classContext;
        JavaClass jclass = classContext.getJavaClass();
        for (Method method : methodList = jclass.getMethods()) {
            BitSet bytecodeSet;
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || (bytecodeSet = classContext.getBytecodeSet(method)) == null || !bytecodeSet.intersects(prescreenSet)) continue;
            if (DEBUG) {
                System.out.println("FindRefComparison: analyzing " + SignatureConverter.convertMethodSignature(methodGen));
            }
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), e);
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        JavaClass jclass = classContext.getJavaClass();
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        LinkedList<WarningWithProperties> refComparisonList = new LinkedList<WarningWithProperties>();
        LinkedList<WarningWithProperties> stringComparisonList = new LinkedList<WarningWithProperties>();
        this.comparedForEqualityInThisMethod = new HashMap<String, Integer>();
        CFG cfg = classContext.getCFG(method);
        DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
        ExceptionSetFactory exceptionSetFactory = classContext.getExceptionSetFactory(method);
        RefComparisonTypeMerger typeMerger = new RefComparisonTypeMerger(this.bugReporter, exceptionSetFactory);
        RefComparisonTypeFrameModelingVisitor visitor = new RefComparisonTypeFrameModelingVisitor(methodGen.getConstantPool(), typeMerger, this.bugReporter);
        SpecialTypeAnalysis typeAnalysis = new SpecialTypeAnalysis(method, methodGen, cfg, dfs, typeMerger, visitor, this.bugReporter, exceptionSetFactory);
        TypeDataflow typeDataflow = new TypeDataflow(cfg, typeAnalysis);
        Profiler profiler = Global.getAnalysisCache().getProfiler();
        profiler.start(SpecialTypeAnalysis.class);
        try {
            typeDataflow.execute();
        }
        finally {
            profiler.end(SpecialTypeAnalysis.class);
        }
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            this.inspectLocation(jclass, cpg, method, methodGen, refComparisonList, stringComparisonList, visitor, typeDataflow, location);
        }
        if (stringComparisonList.isEmpty() && refComparisonList.isEmpty()) {
            return;
        }
        boolean likelyTestcase = TestCaseDetector.likelyTestCase(XFactory.createXMethod(jclass, method));
        this.decorateWarnings(stringComparisonList, warn -> {
            if (this.mightBeLaterCheckedUsingEquals(warn)) {
                warn.propertySet.addProperty(RefComparisonWarningProperty.SAW_CALL_TO_EQUALS);
            }
            if (likelyTestcase) {
                warn.propertySet.addProperty(RefComparisonWarningProperty.COMPARE_IN_TEST_CASE);
            }
        });
        this.decorateWarnings(refComparisonList, warn -> {
            if (likelyTestcase) {
                warn.propertySet.addProperty(RefComparisonWarningProperty.COMPARE_IN_TEST_CASE);
            }
            if (this.mightBeLaterCheckedUsingEquals(warn)) {
                warn.propertySet.addProperty(RefComparisonWarningProperty.SAW_CALL_TO_EQUALS);
            }
        });
        boolean relaxed = FindBugsAnalysisFeatures.isRelaxedMode();
        this.reportBest(classContext, method, stringComparisonList, relaxed);
        this.reportBest(classContext, method, refComparisonList, relaxed);
    }

    boolean mightBeLaterCheckedUsingEquals(WarningWithProperties warning) {
        for (BugAnnotation bugAnnotation : warning.instance.getAnnotations()) {
            String signature;
            Integer pc;
            if (!(bugAnnotation instanceof TypeAnnotation) || (pc = this.comparedForEqualityInThisMethod.get(signature = ((TypeAnnotation)bugAnnotation).getTypeDescriptor())) == null || pc <= warning.location.getHandle().getPosition()) continue;
            return true;
        }
        return false;
    }

    private void inspectLocation(JavaClass jclass, ConstantPoolGen cpg, Method method, MethodGen methodGen, LinkedList<WarningWithProperties> refComparisonList, LinkedList<WarningWithProperties> stringComparisonList, RefComparisonTypeFrameModelingVisitor visitor, TypeDataflow typeDataflow, Location location) throws DataflowAnalysisException {
        Instruction ins = location.getHandle().getInstruction();
        short opcode = ins.getOpcode();
        if (opcode == 165 || opcode == 166) {
            this.checkRefComparison(location, jclass, method, methodGen, visitor, typeDataflow, stringComparisonList, refComparisonList);
        } else if (ins instanceof InvokeInstruction) {
            InvokeInstruction inv = (InvokeInstruction)ins;
            boolean isStatic = inv instanceof INVOKESTATIC;
            String className = inv.getClassName(cpg);
            String methodName = inv.getMethodName(cpg);
            String methodSig = inv.getSignature(cpg);
            if ("assertSame".equals(methodName) && "(Ljava/lang/Object;Ljava/lang/Object;)V".equals(methodSig)) {
                this.checkRefComparison(location, jclass, method, methodGen, visitor, typeDataflow, stringComparisonList, refComparisonList);
            } else if ("assertFalse".equals(methodName) && "(Z)V".equals(methodSig)) {
                SourceLineAnnotation lastLocation = this.bugAccumulator.getLastBugLocation();
                InstructionHandle prevHandle = location.getHandle().getPrev();
                if (lastLocation != null && prevHandle != null && lastLocation.getEndBytecode() == prevHandle.getPosition()) {
                    this.bugAccumulator.forgetLastBug();
                    if (DEBUG) {
                        System.out.println("Forgetting last bug due to call to " + className + "." + methodName);
                    }
                }
            } else {
                boolean equalsMethod;
                boolean bl = equalsMethod = !isStatic && "equals".equals(methodName) && "(Ljava/lang/Object;)Z".equals(methodSig) || isStatic && "assertEquals".equals(methodName) && "(Ljava/lang/Object;Ljava/lang/Object;)V".equals(methodSig) || isStatic && "equal".equals(methodName) && "(Ljava/lang/Object;Ljava/lang/Object;)Z".equals(methodSig) && "com.google.common.base.Objects".equals(className) || isStatic && "equals".equals(methodName) && "(Ljava/lang/Object;Ljava/lang/Object;)Z".equals(methodSig) && "java.util.Objects".equals(className);
                if (equalsMethod) {
                    this.checkEqualsComparison(location, jclass, method, methodGen, cpg, typeDataflow);
                }
            }
        }
    }

    private void decorateWarnings(LinkedList<WarningWithProperties> stringComparisonList, WarningDecorator warningDecorator) {
        for (WarningWithProperties warn : stringComparisonList) {
            warningDecorator.decorate(warn);
            warn.propertySet.decorateBugInstance(warn.instance);
        }
    }

    private void reportBest(ClassContext classContext, Method method, LinkedList<WarningWithProperties> warningList, boolean relaxed) {
        int priority;
        if (!relaxed) {
            // empty if block
        }
        boolean reportAll = true;
        int bestPriority = Integer.MAX_VALUE;
        for (WarningWithProperties warn : warningList) {
            priority = warn.instance.getPriority();
            if (bestPriority > priority) {
                bestPriority = priority;
            }
            if (!reportAll) continue;
            if (relaxed) {
                WarningPropertyUtil.addPropertiesForDataMining(warn.propertySet, classContext, method, warn.location);
                warn.propertySet.decorateBugInstance(warn.instance);
            }
            this.bugAccumulator.accumulateBug(warn.instance, warn.sourceLine);
        }
        if (!reportAll) {
            for (WarningWithProperties warn : warningList) {
                priority = warn.instance.getPriority();
                if (priority > bestPriority) continue;
                this.bugAccumulator.accumulateBug(warn.instance, warn.sourceLine);
            }
        }
    }

    private void checkRefComparison(Location location, JavaClass jclass, Method method, MethodGen methodGen, RefComparisonTypeFrameModelingVisitor visitor, TypeDataflow typeDataflow, List<WarningWithProperties> stringComparisonList, List<WarningWithProperties> refComparisonList) throws DataflowAnalysisException {
        InstructionHandle handle = location.getHandle();
        TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
        if (frame.getStackDepth() < 2) {
            throw new DataflowAnalysisException("Stack underflow", methodGen, handle);
        }
        int numSlots = frame.getNumSlots();
        Type lhsType = (Type)frame.getValue(numSlots - 2);
        Type rhsType = (Type)frame.getValue(numSlots - 1);
        if (lhsType instanceof NullType || rhsType instanceof NullType) {
            return;
        }
        if (lhsType instanceof ReferenceType && rhsType instanceof ReferenceType) {
            IncompatibleTypes result = IncompatibleTypes.getPriorityForAssumingCompatible(lhsType, rhsType, true);
            if (result != IncompatibleTypes.SEEMS_OK && result != IncompatibleTypes.UNCHECKED) {
                String sourceFile = jclass.getSourceFileName();
                boolean isAssertSame = handle.getInstruction() instanceof INVOKESTATIC;
                if (isAssertSame) {
                    if (this.testingEnabled) {
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "TESTING", result.getPriority()).addClassAndMethod(methodGen, sourceFile).addString("Calling assertSame with two distinct objects").addFoundAndExpectedType(rhsType, lhsType).addSomeSourceForTopTwoStackValues(this.classContext, method, location), SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, handle));
                    }
                } else {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "EC_UNRELATED_TYPES_USING_POINTER_EQUALITY", result.getPriority()).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType, lhsType).addSomeSourceForTopTwoStackValues(this.classContext, method, location), SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, handle));
                }
                return;
            }
            if (lhsType.equals((Object)Type.OBJECT) && rhsType.equals((Object)Type.OBJECT)) {
                return;
            }
            String lhs = SignatureConverter.convert(lhsType.getSignature());
            String rhs = SignatureConverter.convert(rhsType.getSignature());
            if ("java.lang.String".equals(lhs) || "java.lang.String".equals(rhs)) {
                this.handleStringComparison(jclass, method, methodGen, visitor, stringComparisonList, location, lhsType, rhsType);
            } else if (this.suspiciousSet.contains(lhs)) {
                this.handleSuspiciousRefComparison(jclass, method, methodGen, refComparisonList, location, lhs, (ReferenceType)lhsType, (ReferenceType)rhsType);
            } else if (this.suspiciousSet.contains(rhs)) {
                this.handleSuspiciousRefComparison(jclass, method, methodGen, refComparisonList, location, rhs, (ReferenceType)lhsType, (ReferenceType)rhsType);
            }
        }
    }

    private void handleStringComparison(JavaClass jclass, Method method, MethodGen methodGen, RefComparisonTypeFrameModelingVisitor visitor, List<WarningWithProperties> stringComparisonList, Location location, Type lhsType, Type rhsType) {
        if (DEBUG) {
            System.out.println("String/String comparison at " + location.getHandle());
        }
        byte type1 = lhsType.getType();
        byte type2 = rhsType.getType();
        String bugPattern = "ES_COMPARING_STRINGS_WITH_EQ";
        WarningPropertySet<WarningProperty> propertySet = new WarningPropertySet<WarningProperty>();
        if (type1 == 101 && type2 == 101) {
            propertySet.addProperty(RefComparisonWarningProperty.COMPARE_STATIC_STRINGS);
        } else if (type1 == 100 || type2 == 100) {
            propertySet.addProperty(RefComparisonWarningProperty.DYNAMIC_AND_UNKNOWN);
        } else if (type2 == 102 || type1 == 102) {
            bugPattern = "ES_COMPARING_PARAMETER_STRING_WITH_EQ";
            if (methodGen.isPublic() || methodGen.isProtected()) {
                propertySet.addProperty(RefComparisonWarningProperty.STRING_PARAMETER_IN_PUBLIC_METHOD);
            } else {
                propertySet.addProperty(RefComparisonWarningProperty.STRING_PARAMETER);
            }
        } else if (type1 == 101 || type2 == 101) {
            if (lhsType instanceof EmptyStringType || rhsType instanceof EmptyStringType) {
                propertySet.addProperty(RefComparisonWarningProperty.EMPTY_AND_UNKNOWN);
            } else {
                propertySet.addProperty(RefComparisonWarningProperty.STATIC_AND_UNKNOWN);
            }
        } else if (visitor.sawStringIntern()) {
            propertySet.addProperty(RefComparisonWarningProperty.SAW_INTERN);
        }
        String sourceFile = jclass.getSourceFileName();
        BugInstance instance = new BugInstance(this, bugPattern, BASE_ES_PRIORITY).addClassAndMethod(methodGen, sourceFile).addType(STRING_SIGNATURE).describe("TYPE_FOUND").addSomeSourceForTopTwoStackValues(this.classContext, method, location);
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle());
        WarningWithProperties warn = new WarningWithProperties(instance, propertySet, sourceLineAnnotation, location);
        stringComparisonList.add(warn);
    }

    private void handleSuspiciousRefComparison(JavaClass jclass, Method method, MethodGen methodGen, List<WarningWithProperties> refComparisonList, Location location, String lhs, ReferenceType lhsType, ReferenceType rhsType) {
        XField xf = null;
        if (lhsType instanceof FinalConstant) {
            xf = ((FinalConstant)lhsType).getXField();
        } else if (rhsType instanceof FinalConstant) {
            xf = ((FinalConstant)rhsType).getXField();
        }
        String sourceFile = jclass.getSourceFileName();
        String bugPattern = "RC_REF_COMPARISON";
        int priority = 1;
        if ("java.lang.Boolean".equals(lhs)) {
            bugPattern = "RC_REF_COMPARISON_BAD_PRACTICE_BOOLEAN";
            priority = 2;
        } else if (xf != null && xf.isStatic() && xf.isFinal()) {
            bugPattern = "RC_REF_COMPARISON_BAD_PRACTICE";
            if (xf.isPublic() || !methodGen.isPublic()) {
                priority = 2;
            }
        }
        BugInstance instance = new BugInstance(this, bugPattern, priority).addClassAndMethod(methodGen, sourceFile).addType("L" + lhs.replace('.', '/') + ";").describe("TYPE_FOUND");
        if (xf != null) {
            instance.addField(xf).describe("FIELD_VALUE_OF");
        } else {
            instance.addSomeSourceForTopTwoStackValues(this.classContext, method, location);
        }
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle());
        refComparisonList.add(new WarningWithProperties(instance, new WarningPropertySet<WarningProperty>(), sourceLineAnnotation, location));
    }

    void addEqualsCheck(String type, int pc) {
        Integer oldPC = this.comparedForEqualityInThisMethod.get(type);
        if (oldPC == null || pc < oldPC) {
            this.comparedForEqualityInThisMethod.put(type, pc);
        }
    }

    private void checkEqualsComparison(Location location, JavaClass jclass, Method method, MethodGen methodGen, ConstantPoolGen cpg, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        INVOKESTATIC is;
        InstructionHandle handle = location.getHandle();
        InstructionHandle next = handle.getNext();
        if (next != null && next.getInstruction() instanceof INVOKESTATIC && "assertFalse".equals((is = (INVOKESTATIC)next.getInstruction()).getMethodName(cpg))) {
            return;
        }
        String sourceFile = jclass.getSourceFileName();
        TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
        if (frame.getStackDepth() < 2) {
            throw new DataflowAnalysisException("Stack underflow", methodGen, handle);
        }
        int numSlots = frame.getNumSlots();
        Type lhsType_ = (Type)frame.getValue(numSlots - 2);
        Type rhsType_ = (Type)frame.getValue(numSlots - 1);
        if (lhsType_.getType() == 17 || lhsType_.getType() == 20 || rhsType_.getType() == 17 || rhsType_.getType() == 20) {
            return;
        }
        InvokeInstruction inv = (InvokeInstruction)handle.getInstruction();
        MethodAnnotation calledMethodAnnotation = this.getMethodCalledAnnotation(cpg, inv);
        boolean looksLikeTestCase = TestCaseDetector.likelyTestCase(XFactory.createXMethod(methodGen));
        int priorityModifier = 0;
        if (looksLikeTestCase) {
            priorityModifier = 1;
        }
        if (rhsType_.getType() == 21) {
            if (!looksLikeTestCase) {
                try {
                    IsNullValueDataflow isNullDataflow = this.classContext.getIsNullValueDataflow(method);
                    IsNullValueFrame isNullFrame = (IsNullValueFrame)isNullDataflow.getFactAtLocation(location);
                    BugAnnotation a = BugInstance.getSourceForTopStackValue(this.classContext, method, location);
                    int priority = 2;
                    if (a instanceof FieldAnnotation && ((FieldAnnotation)a).isStatic()) {
                        priority = 3;
                    }
                    if (isNullFrame.isValid() && ((IsNullValue)isNullFrame.getTopValue()).isDefinitelyNull()) {
                        String type = "EC_NULL_ARG";
                        if (calledMethodAnnotation != null && calledMethodAnnotation.isStatic()) {
                            type = "DMI_DOH";
                            priority = 3;
                        }
                        BugInstance bug = new BugInstance(this, type, priority + priorityModifier).addClassAndMethod(methodGen, sourceFile).addOptionalAnnotation(calledMethodAnnotation);
                        if ("DMI_DOH".equals(type)) {
                            bug.addString("Use \"== null\" to check for a value being null");
                        }
                        this.bugAccumulator.accumulateBug(bug, SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle()));
                    }
                }
                catch (CFGBuilderException e) {
                    AnalysisContext.logError("Error getting null value analysis", e);
                }
            }
            return;
        }
        if (lhsType_.getType() == 21) {
            return;
        }
        if (!(lhsType_ instanceof ReferenceType) || !(rhsType_ instanceof ReferenceType)) {
            this.bugReporter.logError("equals() used to compare non-object type(s) " + lhsType_ + " and " + rhsType_ + " in " + SignatureConverter.convertMethodSignature(methodGen) + " at " + location.getHandle());
            return;
        }
        IncompatibleTypes result = IncompatibleTypes.getPriorityForAssumingCompatible(lhsType_, rhsType_);
        if (lhsType_ instanceof ArrayType && rhsType_ instanceof ArrayType) {
            String pattern = "EC_BAD_ARRAY_COMPARE";
            IncompatibleTypes result2 = IncompatibleTypes.getPriorityForAssumingCompatible(lhsType_, rhsType_, true);
            if (result2.getPriority() <= 2) {
                pattern = "EC_INCOMPATIBLE_ARRAY_COMPARE";
            } else if (calledMethodAnnotation != null && "org.testng.Assert".equals(calledMethodAnnotation.getClassName())) {
                return;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, pattern, 2).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_, lhsType_).addSomeSourceForTopTwoStackValues(this.classContext, method, location).addOptionalAnnotation(calledMethodAnnotation, "METHOD_CALLED"), SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle()));
            return;
        }
        if (result.getPriority() >= 3) {
            this.addEqualsCheck(lhsType_.getSignature(), handle.getPosition());
            this.addEqualsCheck(rhsType_.getSignature(), handle.getPosition());
        }
        if (result == IncompatibleTypes.SEEMS_OK) {
            return;
        }
        if (result.getPriority() > 3) {
            return;
        }
        if (result == IncompatibleTypes.ARRAY_AND_NON_ARRAY || result == IncompatibleTypes.ARRAY_AND_OBJECT) {
            String rhsSig;
            String lhsSig = lhsType_.getSignature();
            boolean allOk = this.checkForWeirdEquals(lhsSig, rhsSig = rhsType_.getSignature(), new HashSet<XMethod>());
            if (allOk) {
                priorityModifier += 2;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EC_ARRAY_AND_NONARRAY", result.getPriority() + priorityModifier).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_, lhsType_).addSomeSourceForTopTwoStackValues(this.classContext, method, location).addOptionalAnnotation(calledMethodAnnotation, "METHOD_CALLED"), SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle()));
        } else if (result == IncompatibleTypes.INCOMPATIBLE_CLASSES) {
            HashSet<XMethod> targets;
            boolean allOk;
            boolean core;
            String lhsSig = lhsType_.getSignature();
            String rhsSig = rhsType_.getSignature();
            boolean bl = core = lhsSig.startsWith("Ljava") && rhsSig.startsWith("Ljava");
            if (core) {
                looksLikeTestCase = false;
                priorityModifier = 0;
            }
            if (allOk = this.checkForWeirdEquals(lhsSig, rhsSig, targets = new HashSet<XMethod>())) {
                priorityModifier += 2;
            }
            int priority = result.getPriority() + priorityModifier;
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EC_UNRELATED_TYPES", priority).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_, lhsType_).addSomeSourceForTopTwoStackValues(this.classContext, method, location).addEqualsMethodUsed(targets).addOptionalAnnotation(calledMethodAnnotation, "METHOD_CALLED"), SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle()));
        } else if (result == IncompatibleTypes.UNRELATED_CLASS_AND_INTERFACE || result == IncompatibleTypes.UNRELATED_FINAL_CLASS_AND_INTERFACE) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EC_UNRELATED_CLASS_AND_INTERFACE", result.getPriority() + priorityModifier).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_, lhsType_).addSomeSourceForTopTwoStackValues(this.classContext, method, location).addEqualsMethodUsed(DescriptorFactory.createClassDescriptorFromSignature(lhsType_.getSignature())).addOptionalAnnotation(calledMethodAnnotation, "METHOD_CALLED"), SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle()));
        } else if (result == IncompatibleTypes.UNRELATED_INTERFACES) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EC_UNRELATED_INTERFACES", result.getPriority() + priorityModifier).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_, lhsType_).addSomeSourceForTopTwoStackValues(this.classContext, method, location).addEqualsMethodUsed(DescriptorFactory.createClassDescriptorFromSignature(lhsType_.getSignature())).addOptionalAnnotation(calledMethodAnnotation, "METHOD_CALLED"), SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle()));
        } else if (result != IncompatibleTypes.UNCHECKED && result.getPriority() <= 3) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EC_UNRELATED_TYPES", result.getPriority() + priorityModifier).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_, lhsType_).addSomeSourceForTopTwoStackValues(this.classContext, method, location).addOptionalAnnotation(calledMethodAnnotation, "METHOD_CALLED"), SourceLineAnnotation.fromVisitedInstruction(this.classContext, methodGen, sourceFile, location.getHandle()));
        }
    }

    @CheckForNull
    public MethodAnnotation getMethodCalledAnnotation(ConstantPoolGen cpg, InvokeInstruction inv) {
        MethodDescriptor invokedMethod = this.getInvokedMethod(cpg, inv);
        boolean standardEquals = "equals".equals(invokedMethod.getName()) && "(Ljava/lang/Object;)Z".equals(invokedMethod.getSignature()) && !invokedMethod.isStatic();
        return standardEquals ? null : MethodAnnotation.fromMethodDescriptor(invokedMethod);
    }

    public MethodDescriptor getInvokedMethod(ConstantPoolGen cpg, InvokeInstruction inv) {
        String invoked = inv.getClassName(cpg);
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        MethodDescriptor invokedMethod = DescriptorFactory.instance().getMethodDescriptor(ClassName.toSlashedClassName(invoked), methodName, methodSig, inv instanceof INVOKESTATIC);
        return invokedMethod;
    }

    private boolean checkForWeirdEquals(String lhsSig, String rhsSig, Set<XMethod> targets) {
        boolean allOk = false;
        try {
            ClassSummary classSummary = AnalysisContext.currentAnalysisContext().getClassSummary();
            ClassDescriptor expectedClassDescriptor = DescriptorFactory.createClassDescriptorFromSignature(lhsSig);
            ClassDescriptor actualClassDescriptor = DescriptorFactory.createClassDescriptorFromSignature(rhsSig);
            targets.addAll(Hierarchy2.resolveVirtualMethodCallTargets(expectedClassDescriptor, "equals", "(Ljava/lang/Object;)Z", false, false));
            allOk = targets.size() > 0;
            for (XMethod m2 : targets) {
                if (classSummary.mightBeEqualTo(m2.getClassDescriptor(), actualClassDescriptor)) continue;
                allOk = false;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        return allOk;
    }

    @Override
    public void report() {
    }

    static {
        DEFAULT_SUSPICIOUS_SET.add("java.lang.Boolean");
        DEFAULT_SUSPICIOUS_SET.add("java.lang.Byte");
        DEFAULT_SUSPICIOUS_SET.add("java.lang.Character");
        DEFAULT_SUSPICIOUS_SET.add("java.lang.Double");
        DEFAULT_SUSPICIOUS_SET.add("java.lang.Float");
        DEFAULT_SUSPICIOUS_SET.add("java.lang.Integer");
        DEFAULT_SUSPICIOUS_SET.add("java.lang.Long");
        DEFAULT_SUSPICIOUS_SET.add("java.lang.Short");
        invokeInstanceSet = new BitSet();
        invokeInstanceSet.set(182);
        invokeInstanceSet.set(185);
        invokeInstanceSet.set(183);
        invokeInstanceSet.set(184);
        prescreenSet = new BitSet();
        prescreenSet.or(invokeInstanceSet);
        prescreenSet.set(165);
        prescreenSet.set(166);
        dynamicStringTypeInstance = new DynamicStringType();
        staticStringTypeInstance = new StaticStringType();
        emptyStringTypeInstance = new EmptyStringType();
        parameterStringTypeInstance = new ParameterStringType();
    }

    private static class RefComparisonTypeMerger
    extends StandardTypeMerger {
        public RefComparisonTypeMerger(RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
            super(lookupFailureCallback, exceptionSetFactory);
        }

        @Override
        protected boolean isReferenceType(byte type) {
            return super.isReferenceType(type) || type == 101 || type == 100;
        }

        @Override
        protected ReferenceType mergeReferenceTypes(ReferenceType aRef, ReferenceType bRef) throws DataflowAnalysisException {
            byte aType = aRef.getType();
            byte bType = bRef.getType();
            if (this.isExtendedStringType(aType) || this.isExtendedStringType(bType)) {
                if (aType == bType) {
                    return aRef;
                }
                if (this.isExtendedStringType(aType)) {
                    aRef = Type.STRING;
                }
                if (this.isExtendedStringType(bType)) {
                    bRef = Type.STRING;
                }
            }
            return super.mergeReferenceTypes(aRef, bRef);
        }

        private boolean isExtendedStringType(byte type) {
            return type == 100 || type == 101 || type == 102;
        }
    }

    private static class RefComparisonTypeFrameModelingVisitor
    extends TypeFrameModelingVisitor {
        private final RepositoryLookupFailureCallback lookupFailureCallback;
        private boolean sawStringIntern;

        public RefComparisonTypeFrameModelingVisitor(ConstantPoolGen cpg, TypeMerger typeMerger, RepositoryLookupFailureCallback lookupFailureCallback) {
            super(cpg, typeMerger);
            this.lookupFailureCallback = lookupFailureCallback;
            this.sawStringIntern = false;
        }

        public boolean sawStringIntern() {
            return this.sawStringIntern;
        }

        @Override
        public void visitINVOKESTATIC(INVOKESTATIC obj) {
            if (this.returnsString((InvokeInstruction)obj)) {
                this.consumeStack((Instruction)obj);
                String className = obj.getClassName(this.getCPG());
                if ("java.lang.String".equals(className)) {
                    this.pushValue(dynamicStringTypeInstance);
                } else {
                    this.pushReturnType((InvokeInstruction)obj);
                }
            } else {
                super.visitINVOKESTATIC(obj);
            }
        }

        @Override
        public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
            if (this.returnsString((InvokeInstruction)obj)) {
                this.handleInstanceMethod((InvokeInstruction)obj);
            } else {
                super.visitINVOKESPECIAL(obj);
            }
        }

        @Override
        public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
            if (this.returnsString((InvokeInstruction)obj)) {
                this.handleInstanceMethod((InvokeInstruction)obj);
            } else {
                super.visitINVOKEINTERFACE(obj);
            }
        }

        @Override
        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
            if (this.returnsString((InvokeInstruction)obj)) {
                this.handleInstanceMethod((InvokeInstruction)obj);
            } else {
                super.visitINVOKEVIRTUAL(obj);
            }
        }

        private boolean returnsString(InvokeInstruction inv) {
            String methodSig = inv.getSignature(this.getCPG());
            return methodSig.endsWith(")Ljava/lang/String;");
        }

        private void handleInstanceMethod(InvokeInstruction obj) {
            assert (this.returnsString(obj));
            this.consumeStack((Instruction)obj);
            String className = obj.getClassName(this.getCPG());
            String methodName = obj.getName(this.getCPG());
            if ("intern".equals(methodName) && "java.lang.String".equals(className)) {
                this.sawStringIntern = true;
                this.pushValue(staticStringTypeInstance);
            } else if ("toString".equals(methodName) || "java.lang.String".equals(className)) {
                this.pushValue(dynamicStringTypeInstance);
            } else {
                this.pushReturnType(obj);
            }
        }

        @Override
        public void visitLDC(LDC obj) {
            Type type = obj.getType(this.getCPG());
            if (this.isString(type)) {
                Object value = obj.getValue(this.getCPG());
                if (value instanceof String && ((String)value).length() == 0) {
                    this.pushValue(emptyStringTypeInstance);
                } else {
                    this.pushValue(staticStringTypeInstance);
                }
            } else {
                this.pushValue(type);
            }
        }

        @Override
        public void visitLDC2_W(LDC2_W obj) {
            Type type = obj.getType(this.getCPG());
            this.pushValue(this.isString(type) ? staticStringTypeInstance : type);
        }

        private boolean isString(Type type) {
            return FindRefComparison.STRING_SIGNATURE.equals(type.getSignature());
        }

        @Override
        public void visitGETSTATIC(GETSTATIC obj) {
            Object type = obj.getType(this.getCPG());
            XField xf = XFactory.createXField((FieldInstruction)obj, this.cpg);
            if (xf.isFinal()) {
                FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                OpcodeStack.Item summary = fieldSummary.getSummary(xf);
                if (summary.isNull()) {
                    this.pushValue(TypeFrame.getNullType());
                    return;
                }
                String slashedClassName = ClassName.fromFieldSignature(type.getSignature());
                if (slashedClassName != null) {
                    String dottedClassName = ClassName.toDottedClassName(slashedClassName);
                    if (DEFAULT_SUSPICIOUS_SET.contains(dottedClassName)) {
                        type = new FinalConstant(dottedClassName, xf);
                        this.consumeStack((Instruction)obj);
                        this.pushValue((Type)type);
                        return;
                    }
                }
            }
            if (FindRefComparison.STRING_SIGNATURE.equals(type.getSignature())) {
                this.handleLoad((FieldInstruction)obj);
            } else {
                super.visitGETSTATIC(obj);
            }
        }

        @Override
        public void visitGETFIELD(GETFIELD obj) {
            Object type = obj.getType(this.getCPG());
            if (FindRefComparison.STRING_SIGNATURE.equals(type.getSignature())) {
                this.handleLoad((FieldInstruction)obj);
            } else {
                XField xf = XFactory.createXField((FieldInstruction)obj, this.cpg);
                if (xf.isFinal()) {
                    FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                    OpcodeStack.Item summary = fieldSummary.getSummary(xf);
                    if (summary.isNull()) {
                        this.consumeStack((Instruction)obj);
                        this.pushValue(TypeFrame.getNullType());
                        return;
                    }
                    String slashedClassName = ClassName.fromFieldSignature(type.getSignature());
                    if (slashedClassName != null) {
                        String dottedClassName = ClassName.toDottedClassName(slashedClassName);
                        if (DEFAULT_SUSPICIOUS_SET.contains(dottedClassName)) {
                            type = new FinalConstant(dottedClassName, xf);
                            this.consumeStack((Instruction)obj);
                            this.pushValue((Type)type);
                            return;
                        }
                    }
                }
                super.visitGETFIELD(obj);
            }
        }

        private void handleLoad(FieldInstruction obj) {
            this.consumeStack((Instruction)obj);
            Type type = obj.getType(this.getCPG());
            if (!FindRefComparison.STRING_SIGNATURE.equals(type.getSignature())) {
                throw new IllegalArgumentException("type is not String: " + type);
            }
            try {
                String className = obj.getClassName(this.getCPG());
                String fieldName = obj.getName(this.getCPG());
                Field field = Hierarchy.findField(className, fieldName);
                if (field != null) {
                    if (field.isFinal()) {
                        this.pushValue(staticStringTypeInstance);
                    } else {
                        this.pushValue(type);
                    }
                    return;
                }
            }
            catch (ClassNotFoundException ex) {
                this.lookupFailureCallback.reportMissingClass(ex);
            }
            this.pushValue(type);
        }
    }

    private static final class SpecialTypeAnalysis
    extends TypeAnalysis {
        private SpecialTypeAnalysis(Method method, MethodGen methodGen, CFG cfg, DepthFirstSearch dfs, TypeMerger typeMerger, TypeFrameModelingVisitor visitor, RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
            super(method, methodGen, cfg, dfs, typeMerger, visitor, lookupFailureCallback, exceptionSetFactory);
        }

        @Override
        public void initEntryFact(TypeFrame result) {
            super.initEntryFact(result);
            for (int i = 0; i < this.methodGen.getMaxLocals(); ++i) {
                Type t = (Type)result.getValue(i);
                if (!t.equals((Object)Type.STRING)) continue;
                result.setValue(i, parameterStringTypeInstance);
            }
        }
    }

    private static interface WarningDecorator {
        public void decorate(WarningWithProperties var1);
    }

    private static class WarningWithProperties {
        final BugInstance instance;
        final SourceLineAnnotation sourceLine;
        final WarningPropertySet<WarningProperty> propertySet;
        final Location location;

        WarningWithProperties(BugInstance warning, WarningPropertySet<WarningProperty> propertySet, SourceLineAnnotation sourceLine, Location location) {
            this.instance = warning;
            this.propertySet = propertySet;
            this.sourceLine = sourceLine;
            this.location = location;
        }
    }

    public static class EmptyStringType
    extends StaticStringType {
        private static final long serialVersionUID = 1L;

        @Override
        public byte getType() {
            return 101;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public String toString() {
            return "<empty string>";
        }
    }

    public static class FinalConstant
    extends ObjectType {
        private static final long serialVersionUID = 1L;
        @Nonnull
        final XField field;

        public FinalConstant(@DottedClassName String type, @Nonnull XField field) {
            super(type);
            this.field = field;
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.field.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FinalConstant)) {
                return false;
            }
            FinalConstant other = (FinalConstant)((Object)obj);
            return super.equals((Object)other) && this.field.equals(other.field);
        }

        public XField getXField() {
            return this.field;
        }

        public String toString() {
            return super.toString() + " " + this.field;
        }
    }

    public static class DynamicStringType
    extends ObjectType {
        private static final long serialVersionUID = 1L;

        public DynamicStringType() {
            super("java.lang.String");
        }

        public byte getType() {
            return 100;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<dynamic string>";
        }
    }

    public static class StaticStringType
    extends ObjectType {
        private static final long serialVersionUID = 1L;

        public StaticStringType() {
            super("java.lang.String");
        }

        public byte getType() {
            return 101;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<static string>";
        }
    }

    public static class ParameterStringType
    extends ObjectType {
        private static final long serialVersionUID = 1L;

        public ParameterStringType() {
            super("java.lang.String");
        }

        public byte getType() {
            return 102;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<parameter string>";
        }
    }
}

