/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.props.AbstractWarningProperty;
import edu.umd.cs.findbugs.props.PriorityAdjustment;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class Naming
extends PreorderVisitor
implements Detector {
    String baseClassName;
    boolean classIsPublicOrProtected;
    HashMap<String, TreeSet<XMethod>> canonicalToXMethod = new HashMap();
    HashSet<String> visited = new HashSet();
    private final BugReporter bugReporter;
    boolean hasBadMethodNames;
    boolean hasBadFieldNames;
    private boolean isEclipseNLS;
    private static final Pattern sigType = Pattern.compile("L([^;]*/)?([^/]+;)");

    @CheckForNull
    public static XMethod definedIn(JavaClass clazz, XMethod m) {
        for (Method m2 : clazz.getMethods()) {
            if (!m.getName().equals(m2.getName()) || !m.getSignature().equals(m2.getSignature()) || m.isStatic() != m2.isStatic()) continue;
            return XFactory.createXMethod(clazz, m2);
        }
        return null;
    }

    public static boolean confusingMethodNamesWrongCapitalization(XMethod m1, XMethod m2) {
        return m1.isStatic() == m2.isStatic() && !m1.getClassName().equals(m2.getClassName()) && !m1.getName().equals(m2.getName()) && m1.getName().equalsIgnoreCase(m2.getName()) && Naming.removePackageNamesFromSignature(m1.getSignature()).equals(Naming.removePackageNamesFromSignature(m2.getSignature()));
    }

    public static boolean confusingMethodNamesWrongPackage(XMethod m1, XMethod m2) {
        return m1.isStatic() == m2.isStatic() && !m1.getClassName().equals(m2.getClassName()) && m1.getName().equals(m2.getName()) && !m1.getSignature().equals(m2.getSignature()) && Naming.removePackageNamesFromSignature(m1.getSignature()).equals(Naming.removePackageNamesFromSignature(m2.getSignature()));
    }

    public Naming(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    private boolean checkSuper(XMethod m, Set<XMethod> others) {
        if (m.isStatic()) {
            return false;
        }
        if ("<init>".equals(m.getName()) || "<clinit>".equals(m.getName())) {
            return false;
        }
        for (XMethod m2 : others) {
            try {
                if (!Naming.confusingMethodNamesWrongCapitalization(m, m2) && !Naming.confusingMethodNamesWrongPackage(m, m2) || !Repository.instanceOf((String)m.getClassName(), (String)m2.getClassName())) continue;
                WarningPropertySet<NamingProperty> propertySet = new WarningPropertySet<NamingProperty>();
                int priority = 1;
                boolean intentional = false;
                XMethod m3 = null;
                try {
                    JavaClass clazz = Repository.lookupClass((String)m.getClassName());
                    m3 = Naming.definedIn(clazz, m2);
                    if (m3 != null) {
                        priority = 2;
                        intentional = true;
                    }
                }
                catch (ClassNotFoundException e) {
                    ++priority;
                    AnalysisContext.reportMissingClass(e);
                }
                XFactory xFactory = AnalysisContext.currentXFactory();
                if (m3 == null && xFactory.isCalled(m)) {
                    propertySet.addProperty(NamingProperty.METHOD_IS_CALLED);
                } else if (m.isDeprecated() || m2.isDeprecated()) {
                    propertySet.addProperty(NamingProperty.METHOD_IS_DEPRECATED);
                }
                if (!m.getName().equals(m2.getName()) && m.getName().equalsIgnoreCase(m2.getName())) {
                    String pattern = intentional ? "NM_VERY_CONFUSING_INTENTIONAL" : "NM_VERY_CONFUSING";
                    Set<XMethod> overrides = Hierarchy2.findSuperMethods(m);
                    if (!overrides.isEmpty()) {
                        if (intentional || this.allAbstract(overrides)) break;
                        ++priority;
                    }
                    BugInstance bug = new BugInstance(this, pattern, priority).addClass(m.getClassName()).addMethod(m).addClass(m2.getClassName()).describe("CLASS_SUPERCLASS").addMethod(m2).describe("METHOD_DID_YOU_MEAN_TO_OVERRIDE");
                    if (m3 != null) {
                        bug.addMethod(m3).describe("METHOD_OVERRIDDEN");
                    }
                    propertySet.decorateBugInstance(bug);
                    this.bugReporter.reportBug(bug);
                } else if (!m.getSignature().equals(m2.getSignature()) && Naming.removePackageNamesFromSignature(m.getSignature()).equals(Naming.removePackageNamesFromSignature(m2.getSignature()))) {
                    String pattern = intentional ? "NM_WRONG_PACKAGE_INTENTIONAL" : "NM_WRONG_PACKAGE";
                    Set<XMethod> overrides = Hierarchy2.findSuperMethods(m);
                    if (!overrides.isEmpty()) {
                        if (intentional || this.allAbstract(overrides)) break;
                        ++priority;
                    }
                    Iterator<String> s = new SignatureParser(m.getSignature()).parameterSignatureIterator();
                    Iterator<String> s2 = new SignatureParser(m2.getSignature()).parameterSignatureIterator();
                    while (s.hasNext()) {
                        String p2;
                        String p = s.next();
                        if (p.equals(p2 = s2.next())) continue;
                        BugInstance bug = new BugInstance(this, pattern, priority).addClass(m.getClassName()).addMethod(m).addClass(m2.getClassName()).describe("CLASS_SUPERCLASS").addMethod(m2).describe("METHOD_DID_YOU_MEAN_TO_OVERRIDE").addFoundAndExpectedType(p, p2);
                        if (m3 != null) {
                            bug.addMethod(m3).describe("METHOD_OVERRIDDEN");
                        }
                        propertySet.decorateBugInstance(bug);
                        this.bugReporter.reportBug(bug);
                    }
                }
                return true;
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
        }
        return false;
    }

    private boolean allAbstract(Set<XMethod> overrides) {
        boolean allAbstract = true;
        for (XMethod m4 : overrides) {
            if (m4.isAbstract()) continue;
            allAbstract = false;
        }
        return allAbstract;
    }

    private boolean checkNonSuper(XMethod m, Set<XMethod> others) {
        if (m.isStatic()) {
            return false;
        }
        if (m.getName().startsWith("<init>") || m.getName().startsWith("<clinit>")) {
            return false;
        }
        for (XMethod m2 : others) {
            XMethod mm2;
            XMethod mm1;
            if (!Naming.confusingMethodNamesWrongCapitalization(m, m2)) continue;
            if (m.compareTo(m2) < 0) {
                mm1 = m;
                mm2 = m2;
            } else {
                mm1 = m2;
                mm2 = m;
            }
            this.bugReporter.reportBug(new BugInstance(this, "NM_CONFUSING", 3).addClass(mm1.getClassName()).addMethod(mm1).addClass(mm2.getClassName()).addMethod(mm2));
            return true;
        }
        return false;
    }

    @Override
    public void report() {
        for (Map.Entry<String, TreeSet<XMethod>> e : this.canonicalToXMethod.entrySet()) {
            TreeSet<XMethod> conflictingMethods = e.getValue();
            HashSet<String> trueNames = new HashSet<String>();
            for (XMethod m : conflictingMethods) {
                trueNames.add(m.getName() + m.getSignature());
            }
            if (trueNames.size() <= 1) continue;
            Iterator<XMethod> j = conflictingMethods.iterator();
            while (j.hasNext()) {
                if (!this.checkSuper(j.next(), conflictingMethods)) continue;
                j.remove();
            }
            for (XMethod conflictingMethod : conflictingMethods) {
                if (this.checkNonSuper(conflictingMethod, conflictingMethods)) break;
            }
        }
    }

    public String stripPackageName(String className) {
        if (className.indexOf(46) >= 0) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        if (className.indexOf(47) >= 0) {
            return className.substring(className.lastIndexOf(47) + 1);
        }
        return className;
    }

    public boolean sameSimpleName(String class1, String class2) {
        return class1 != null && class2 != null && this.stripPackageName(class1).equals(this.stripPackageName(class2));
    }

    @Override
    public void visitJavaClass(JavaClass obj) {
        if (BCELUtil.isSynthetic(obj)) {
            return;
        }
        String name = obj.getClassName();
        if (!this.visited.add(name)) {
            return;
        }
        String superClassName = obj.getSuperclassName();
        if (!"java.lang.Object".equals(name)) {
            if (this.sameSimpleName(superClassName, name)) {
                this.bugReporter.reportBug(new BugInstance(this, "NM_SAME_SIMPLE_NAME_AS_SUPERCLASS", 1).addClass(name).addClass(superClassName));
            }
            for (String interfaceName : obj.getInterfaceNames()) {
                if (!this.sameSimpleName(interfaceName, name)) continue;
                this.bugReporter.reportBug(new BugInstance(this, "NM_SAME_SIMPLE_NAME_AS_INTERFACE", 2).addClass(name).addClass(interfaceName));
            }
        }
        if (obj.isInterface()) {
            return;
        }
        if ("java.lang.Object".equals(superClassName) && !this.visited.contains(superClassName)) {
            try {
                this.visitJavaClass(obj.getSuperClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        super.visitJavaClass(obj);
    }

    private static boolean mightInheritFromException(ClassDescriptor d) {
        while (d != null) {
            try {
                if ("java.lang.Exception".equals(d.getDottedClassName())) {
                    return true;
                }
                XClass classNameAndInfo = Global.getAnalysisCache().getClassAnalysis(XClass.class, d);
                d = classNameAndInfo.getSuperclassDescriptor();
            }
            catch (CheckedAnalysisException e) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visit(JavaClass obj) {
        String name = obj.getClassName();
        String[] parts = name.split("[$+.]");
        this.baseClassName = parts[parts.length - 1];
        for (String p : name.split("[.]")) {
            if (p.length() != 1) continue;
            return;
        }
        if (name.indexOf("Proto$") >= 0) {
            return;
        }
        boolean bl = this.classIsPublicOrProtected = obj.isPublic() || obj.isProtected();
        if (Character.isLetter(this.baseClassName.charAt(0)) && !Character.isUpperCase(this.baseClassName.charAt(0)) && this.baseClassName.indexOf(95) == -1) {
            int priority = this.classIsPublicOrProtected ? 2 : 3;
            this.bugReporter.reportBug(new BugInstance(this, "NM_CLASS_NAMING_CONVENTION", priority).addClass(this));
        }
        if (name.endsWith("Exception") && !Naming.mightInheritFromException(DescriptorFactory.createClassDescriptor(obj))) {
            this.bugReporter.reportBug(new BugInstance(this, "NM_CLASS_NOT_EXCEPTION", 2).addClass(this));
        }
        int badFieldNames = 0;
        for (Field f : obj.getFields()) {
            if (f.getName().length() < 2 || !this.badFieldName(f)) continue;
            ++badFieldNames;
        }
        this.hasBadFieldNames = badFieldNames > 3 && badFieldNames > obj.getFields().length / 3;
        int badMethodNames = 0;
        for (Method m : obj.getMethods()) {
            if (!this.badMethodName(m.getName())) continue;
            ++badMethodNames;
        }
        this.hasBadMethodNames = badMethodNames > 3 && badMethodNames > obj.getMethods().length / 3;
        this.isEclipseNLS = "org.eclipse.osgi.util.NLS".equals(obj.getSuperclassName());
        super.visit(obj);
    }

    @Override
    public void visit(Field obj) {
        int flags;
        if (this.getFieldName().length() == 1) {
            return;
        }
        if (this.isEclipseNLS && ((flags = obj.getAccessFlags()) & 8) != 0 && (flags & 1) != 0 && "Ljava/lang/String;".equals(this.getFieldSig())) {
            return;
        }
        if (this.badFieldName(obj)) {
            this.bugReporter.reportBug(new BugInstance(this, "NM_FIELD_NAMING_CONVENTION", this.classIsPublicOrProtected && (obj.isPublic() || obj.isProtected()) && !this.hasBadFieldNames ? 2 : 3).addClass(this).addVisitedField(this));
        }
    }

    private boolean badFieldName(Field obj) {
        String fieldName = obj.getName();
        return !obj.isFinal() && Character.isLetter(fieldName.charAt(0)) && !Character.isLowerCase(fieldName.charAt(0)) && fieldName.indexOf(95) == -1 && Character.isLetter(fieldName.charAt(1)) && Character.isLowerCase(fieldName.charAt(1));
    }

    @CheckForNull
    private static String getSignatureOfOuterClass(JavaClass obj) {
        for (Field f : obj.getFields()) {
            if (!f.getName().startsWith("this$")) continue;
            return f.getSignature();
        }
        return null;
    }

    private boolean markedAsNotUsable(Method obj) {
        for (Attribute a : obj.getAttributes()) {
            if (!(a instanceof Deprecated)) continue;
            return true;
        }
        Code code = obj.getCode();
        if (code == null) {
            return false;
        }
        byte[] codeBytes = code.getCode();
        if (codeBytes.length > 1 && codeBytes.length < 10) {
            int lastOpcode = codeBytes[codeBytes.length - 1] & 0xFF;
            if (lastOpcode != 191) {
                return false;
            }
            for (byte b : codeBytes) {
                if ((b & 0xFF) != 177) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @CheckForNull
    private static Method findVoidConstructor(JavaClass clazz) {
        for (Method m : clazz.getMethods()) {
            if (!Naming.isVoidConstructor(clazz, m)) continue;
            return m;
        }
        return null;
    }

    @Override
    public void visit(Method obj) {
        String mName = this.getMethodName();
        if (mName.length() == 1) {
            return;
        }
        if ("isRequestedSessionIdFromURL".equals(mName) || "isRequestedSessionIdFromUrl".equals(mName)) {
            return;
        }
        String sig = this.getMethodSig();
        if (mName.equals(this.baseClassName) && "()V".equals(sig)) {
            Code code = obj.getCode();
            Method realVoidConstructor = Naming.findVoidConstructor(this.getThisClass());
            if (code != null && !this.markedAsNotUsable(obj)) {
                int priority = 2;
                if (this.codeDoesSomething(code)) {
                    --priority;
                } else if (!obj.isPublic() && this.getThisClass().isPublic()) {
                    --priority;
                }
                boolean instanceMembers = false;
                for (Method method : this.getThisClass().getMethods()) {
                    if (method.isStatic() || method == obj || Naming.isVoidConstructor(this.getThisClass(), method)) continue;
                    instanceMembers = true;
                }
                for (Method method : this.getThisClass().getFields()) {
                    if (method.isStatic()) continue;
                    instanceMembers = true;
                }
                if (!this.codeDoesSomething(code) && !instanceMembers && "java/lang/Object".equals(this.getSuperclassName())) {
                    priority += 2;
                }
                if (this.hasBadMethodNames) {
                    ++priority;
                }
                if (!this.getXClass().getAnnotations().isEmpty()) {
                    ++priority;
                }
                if (realVoidConstructor != null) {
                    priority = 3;
                }
                this.bugReporter.reportBug(new BugInstance(this, "NM_METHOD_CONSTRUCTOR_CONFUSION", priority).addClassAndMethod(this).lowerPriorityIfDeprecated());
                return;
            }
        } else if (this.badMethodName(mName)) {
            this.bugReporter.reportBug(new BugInstance(this, "NM_METHOD_NAMING_CONVENTION", this.classIsPublicOrProtected && (obj.isPublic() || obj.isProtected()) && !this.hasBadMethodNames ? 2 : 3).addClassAndMethod(this));
        }
        if (obj.isAbstract()) {
            return;
        }
        if (obj.isPrivate()) {
            return;
        }
        if ("equal".equals(mName) && "(Ljava/lang/Object;)Z".equals(sig)) {
            this.bugReporter.reportBug(new BugInstance(this, "NM_BAD_EQUAL", 1).addClassAndMethod(this).lowerPriorityIfDeprecated());
            return;
        }
        if ("hashcode".equals(mName) && "()I".equals(sig)) {
            this.bugReporter.reportBug(new BugInstance(this, "NM_LCASE_HASHCODE", 1).addClassAndMethod(this).lowerPriorityIfDeprecated());
            return;
        }
        if ("tostring".equals(mName) && "()Ljava/lang/String;".equals(sig)) {
            this.bugReporter.reportBug(new BugInstance(this, "NM_LCASE_TOSTRING", 1).addClassAndMethod(this).lowerPriorityIfDeprecated());
            return;
        }
        if (obj.isPrivate() || obj.isStatic() || "<init>".equals(mName)) {
            return;
        }
        String sig2 = Naming.removePackageNamesFromSignature(sig);
        String allSmall = mName.toLowerCase() + sig2;
        XMethod xm = this.getXMethod();
        TreeSet s = this.canonicalToXMethod.computeIfAbsent(allSmall, k -> new TreeSet());
        s.add(xm);
    }

    private static boolean isVoidConstructor(JavaClass clazz, Method m) {
        String outerClassSignature = Naming.getSignatureOfOuterClass(clazz);
        if (outerClassSignature == null) {
            outerClassSignature = "";
        }
        return "<init>".equals(m.getName()) && m.getSignature().equals("(" + outerClassSignature + ")V");
    }

    private boolean badMethodName(String mName) {
        return mName.length() >= 2 && Character.isLetter(mName.charAt(0)) && !Character.isLowerCase(mName.charAt(0)) && Character.isLetter(mName.charAt(1)) && Character.isLowerCase(mName.charAt(1)) && mName.indexOf(95) == -1;
    }

    private boolean codeDoesSomething(Code code) {
        byte[] codeBytes = code.getCode();
        return codeBytes.length > 1;
    }

    private static String removePackageNamesFromSignature(String sig) {
        int end = sig.indexOf(41);
        Matcher m = sigType.matcher(sig.substring(0, end));
        return m.replaceAll("L$2") + sig.substring(end);
    }

    public static class NamingProperty
    extends AbstractWarningProperty {
        public static final NamingProperty METHOD_IS_CALLED = new NamingProperty("CONFUSING_METHOD_IS_CALLED", PriorityAdjustment.AT_MOST_MEDIUM);
        public static final NamingProperty METHOD_IS_DEPRECATED = new NamingProperty("CONFUSING_METHOD_IS_DEPRECATED", PriorityAdjustment.LOWER_PRIORITY);

        private NamingProperty(String name, PriorityAdjustment priorityAdjustment) {
            super(name, priorityAdjustment);
        }
    }
}

