/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.sarif.Level;
import edu.umd.cs.findbugs.sarif.SarifException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

class Notification {
    @NonNull
    final String id;
    @NonNull
    final String message;
    @NonNull
    final Level level;
    @Nullable
    final SarifException exception;

    Notification(@NonNull String id, @NonNull String message, @NonNull Level level, @Nullable SarifException exception) {
        this.id = Objects.requireNonNull(id);
        this.message = Objects.requireNonNull(message);
        this.level = Objects.requireNonNull(level);
        this.exception = exception;
    }

    JsonObject toJsonObject() {
        JsonObject descriptorJson = new JsonObject();
        descriptorJson.addProperty("id", this.id);
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("text", this.message);
        JsonObject result = new JsonObject();
        result.add("descriptor", (JsonElement)descriptorJson);
        result.add("message", (JsonElement)messageJson);
        result.addProperty("level", this.level.toJsonString());
        if (this.exception != null) {
            result.add("exception", (JsonElement)this.exception.toJsonObject());
        }
        return result;
    }

    static Notification fromError(@NonNull AbstractBugReporter.Error error, @NonNull SourceFinder sourceFinder, @NonNull Map<URI, String> baseToId) {
        String id = String.format("spotbugs-error-%d", error.getSequence());
        Throwable cause = error.getCause();
        if (cause == null) {
            return new Notification(id, error.getMessage(), Level.ERROR, null);
        }
        return new Notification(id, error.getMessage(), Level.ERROR, SarifException.fromThrowable(cause, sourceFinder, baseToId));
    }
}

