/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.sarif.Level;
import edu.umd.cs.findbugs.sarif.Location;
import edu.umd.cs.findbugs.sarif.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class Result {
    final String ruleId;
    final int ruleIndex;
    final Message message;
    final List<Location> locations;
    @NonNull
    final Level level;

    Result(@NonNull String ruleId, int ruleIndex, Message message, List<Location> locations, @NonNull Level level) {
        this.ruleId = Objects.requireNonNull(ruleId);
        this.ruleIndex = ruleIndex;
        this.message = Objects.requireNonNull(message);
        this.locations = Collections.unmodifiableList(Objects.requireNonNull(locations));
        this.level = Objects.requireNonNull(level);
    }

    JsonObject toJsonObject() {
        JsonObject result = new JsonObject();
        result.addProperty("ruleId", this.ruleId);
        result.addProperty("ruleIndex", (Number)this.ruleIndex);
        result.add("message", (JsonElement)this.message.toJsonObject());
        result.addProperty("level", this.level.toJsonString());
        JsonArray locationArray = new JsonArray();
        this.locations.stream().map(Location::toJsonObject).forEach(location -> locationArray.add((JsonElement)location));
        if (locationArray.size() > 0) {
            result.add("locations", (JsonElement)locationArray);
        }
        return result;
    }
}

