/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.sarif.Stack;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class SarifException {
    @NonNull
    final String kind;
    @NonNull
    final String message;
    @NonNull
    final Stack stack;
    @NonNull
    final List<SarifException> innerExceptions;

    SarifException(@NonNull String kind, @NonNull String message, @NonNull Stack stack, @NonNull List<SarifException> innerExceptions) {
        this.kind = Objects.requireNonNull(kind);
        this.message = Objects.requireNonNull(message);
        this.stack = Objects.requireNonNull(stack);
        this.innerExceptions = Collections.unmodifiableList(Objects.requireNonNull(innerExceptions));
    }

    @NonNull
    static SarifException fromThrowable(@NonNull Throwable throwable, @NonNull SourceFinder sourceFinder, @NonNull Map<URI, String> baseToId) {
        String message = throwable.getMessage();
        if (message == null) {
            message = "no message given";
        }
        ArrayList<Throwable> innerThrowables = new ArrayList<Throwable>();
        innerThrowables.add(throwable.getCause());
        innerThrowables.addAll(Arrays.asList(throwable.getSuppressed()));
        List<SarifException> innerExceptions = innerThrowables.stream().filter(Objects::nonNull).map(t -> SarifException.fromThrowable(t, sourceFinder, baseToId)).collect(Collectors.toList());
        return new SarifException(throwable.getClass().getName(), message, Stack.fromThrowable(throwable, sourceFinder, baseToId), innerExceptions);
    }

    JsonObject toJsonObject() {
        JsonObject textJson = new JsonObject();
        textJson.addProperty("text", this.message);
        JsonObject result = new JsonObject();
        result.addProperty("kind", this.kind);
        result.add("message", (JsonElement)textJson);
        result.add("stack", (JsonElement)this.stack.toJsonObject());
        JsonArray exceptionArray = new JsonArray();
        this.innerExceptions.forEach(innerException -> exceptionArray.add((JsonElement)innerException.toJsonObject()));
        if (exceptionArray.size() > 0) {
            result.add("innerExceptions", (JsonElement)exceptionArray);
        }
        return result;
    }
}

