/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sourceViewer;

import edu.umd.cs.findbugs.sourceViewer.HighlightInformation;
import edu.umd.cs.findbugs.sourceViewer.NoWrapBoxView;
import edu.umd.cs.findbugs.sourceViewer.NumberedParagraphView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class NumberedViewFactory
implements ViewFactory {
    final HighlightInformation highlight;

    public NumberedViewFactory(HighlightInformation highlight) {
        this.highlight = highlight;
    }

    @Override
    public View create(Element elem) {
        String kind = elem.getName();
        if (kind != null) {
            if ("content".equals(kind)) {
                return new LabelView(elem);
            }
            if ("paragraph".equals(kind)) {
                return new NumberedParagraphView(elem, this.highlight);
            }
            if ("section".equals(kind)) {
                return new NoWrapBoxView(elem, 1);
            }
            if ("component".equals(kind)) {
                return new ComponentView(elem);
            }
            if ("icon".equals(kind)) {
                return new IconView(elem);
            }
        }
        return new LabelView(elem);
    }
}

