/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import java.util.Arrays;
import java.util.Optional;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BootstrapMethodsUtil {
    public static Optional<Method> getMethodFromBootstrap(BootstrapMethods bms, int index, ConstantPool cp, JavaClass cls) {
        BootstrapMethod bm = bms.getBootstrapMethods()[index];
        for (int arg : bm.getBootstrapArguments()) {
            ConstantMethodHandle cmh;
            Constant c = bms.getConstantPool().getConstant(arg);
            if (!(c instanceof ConstantMethodHandle) || !((c = cp.getConstant((cmh = (ConstantMethodHandle)c).getReferenceIndex())) instanceof ConstantMethodref) && !(c instanceof ConstantInterfaceMethodref)) continue;
            ConstantCP ccp = (ConstantCP)c;
            if (ccp.getClassIndex() != cls.getClassNameIndex()) {
                return Optional.empty();
            }
            ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(ccp.getNameAndTypeIndex());
            Optional<Method> metOpt = Arrays.stream(cls.getMethods()).filter(m -> m.getNameIndex() == cnat.getNameIndex() && m.getSignatureIndex() == cnat.getSignatureIndex()).findAny();
            if (!metOpt.isPresent()) continue;
            return metOpt;
        }
        return Optional.empty();
    }
}

