/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class KotlinUnsafeCastOperatorFilter
implements IFilter {
    private static final String KOTLIN_TYPE_CAST_EXCEPTION = "kotlin/TypeCastException";

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i = methodNode.instructions.getFirst(); i != null; i = i.getNext()) {
            matcher.match(i, output);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(AbstractInsnNode start, IFilterOutput output) {
            if (199 != start.getOpcode()) {
                return;
            }
            this.cursor = start;
            this.nextIsType(187, KotlinUnsafeCastOperatorFilter.KOTLIN_TYPE_CAST_EXCEPTION);
            this.nextIs(89);
            this.nextIs(18);
            if (this.cursor == null) {
                return;
            }
            LdcInsnNode ldc = (LdcInsnNode)this.cursor;
            if (!(ldc.cst instanceof String) || !((String)ldc.cst).startsWith("null cannot be cast to non-null type")) {
                return;
            }
            this.nextIsInvoke(183, KotlinUnsafeCastOperatorFilter.KOTLIN_TYPE_CAST_EXCEPTION, "<init>", "(Ljava/lang/String;)V");
            this.nextIs(191);
            if (this.cursor == null) {
                return;
            }
            if (this.cursor.getNext() != ((JumpInsnNode)start).label) {
                return;
            }
            output.ignore(start, this.cursor);
        }
    }
}

