/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.EditorKit;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.CaretMonitor;

public class SyntaxTester
extends JFrame {
    private JComboBox jCmbLangs;
    private JEditorPane jEdtTest;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JLabel lblCaretPos;
    private JLabel lblToken;

    public SyntaxTester() {
        this.initComponents();
        this.jCmbLangs.setModel(new DefaultComboBoxModel<String>(DefaultSyntaxKit.getContentTypes()));
        this.jCmbLangs.setSelectedItem("text/java");
        new CaretMonitor(this.jEdtTest, this.lblCaretPos);
    }

    private void initComponents() {
        this.lblCaretPos = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEdtTest = new JEditorPane();
        this.lblToken = new JLabel();
        this.jCmbLangs = new JComboBox();
        this.jToolBar1 = new JToolBar();
        this.setDefaultCloseOperation(3);
        this.setTitle("JSyntaxPane Tester");
        this.lblCaretPos.setHorizontalAlignment(11);
        this.lblCaretPos.setText("Caret Position");
        this.jEdtTest.setContentType("");
        this.jEdtTest.setFont(new Font("Monospaced", 0, 13));
        this.jEdtTest.setCaretColor(new Color(153, 204, 255));
        this.jEdtTest.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                SyntaxTester.this.jEdtTestCaretUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jEdtTest);
        this.lblToken.setFont(new Font("Courier New", 0, 12));
        this.lblToken.setText("Token under cursor");
        this.jCmbLangs.setMaximumRowCount(20);
        this.jCmbLangs.setFocusable(false);
        this.jCmbLangs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SyntaxTester.this.jCmbLangsItemStateChanged(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setFocusable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 848, Short.MAX_VALUE).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jCmbLangs, -2, 135, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 574, Short.MAX_VALUE).addComponent(this.lblCaretPos, -2, 119, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblToken, -1, 354, Short.MAX_VALUE).addGap(484, 484, 484)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -2, 387, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblToken, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCaretPos, -1, 21, Short.MAX_VALUE).addComponent(this.jCmbLangs, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void jEdtTestCaretUpdate(CaretEvent evt) {
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(this.jEdtTest);
        if (sDoc != null) {
            Token t = sDoc.getTokenAt(evt.getDot());
            if (t != null) {
                CharSequence tData = t.getText(sDoc);
                if (t.length > 40) {
                    tData = tData.subSequence(0, 40);
                }
                this.lblToken.setText(t.toString() + ": " + tData);
            } else {
                this.lblToken.setText("NO Token at cursor");
            }
        }
    }

    private void jCmbLangsItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String lang = this.jCmbLangs.getSelectedItem().toString();
            String oldText = this.jEdtTest.getText();
            this.jEdtTest.setContentType(lang);
            this.jToolBar1.removeAll();
            EditorKit kit = this.jEdtTest.getEditorKit();
            if (kit instanceof DefaultSyntaxKit) {
                DefaultSyntaxKit defaultSyntaxKit = (DefaultSyntaxKit)kit;
                defaultSyntaxKit.addToolBarActions(this.jEdtTest, this.jToolBar1);
            }
            this.jToolBar1.validate();
            try {
                this.jEdtTest.read(new StringReader(oldText), (Object)lang);
            }
            catch (IOException ex) {
                Logger.getLogger(SyntaxTester.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.jEdtTest.requestFocusInWindow();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSyntaxKit.initKit();
                    new SyntaxTester().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(2);
                }
            }
        });
    }
}

