/*
 * Copyright 2008 Ayman Al-Sairafi ayman.alsairafi@gmail.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License
 *       at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jsyntaxpane.actions.gui;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jsyntaxpane.actions.HTMLPreviewAction;

/**
 *
 * @author Ayman Al-Sairafi
 */
public class HTMLPreviewFrame extends javax.swing.JFrame implements DocumentListener {

	Document doc;
	/**
	 * Creates new form HTMLPreviewFrame
	 * @param doc
	 */
	public HTMLPreviewFrame(Document doc) {
		initComponents();
		this.doc = doc;
		doc.addDocumentListener(this);
		updateHTML();
	}

	private void updateHTML() {
		try {
			jEdtHtml.setText(doc.getText(0, doc.getLength()));
		} catch (BadLocationException ex) {
			Logger.getLogger(HTMLPreviewFrame.class.getName()).log(Level.SEVERE, null, ex);
		}
	}

	/**
	 * This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jEdtHtml = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("HTML Preview");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                onWindowClosed(evt);
            }
        });

        jEdtHtml.setContentType("text/html");
        jEdtHtml.setEditable(false);
        jScrollPane1.setViewportView(jEdtHtml);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 688, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 449, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void onWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_onWindowClosed
		doc.removeDocumentListener(this);
		doc.putProperty(HTMLPreviewAction.HTML_PREVIEW_WINDOW, null);
		doc = null;
    }//GEN-LAST:event_onWindowClosed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JEditorPane jEdtHtml;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

	@Override
	public void insertUpdate(DocumentEvent e) {
		updateHTML();
	}

	@Override
	public void removeUpdate(DocumentEvent e) {
		updateHTML();
	}

	@Override
	public void changedUpdate(DocumentEvent e) {
		updateHTML();
	}
}
