/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/Api.java#2 $
 *
 * Copyright (c) 2007 Network Appliance, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Define a Zephyr api call to be used by {@link com.netapp.common.zapi.ZAPIRunner}.
 * A class with this annotation must also annotate with
 * {@link Input} and {@link Output} annotations the appropriate
 * parameters and return values to send to the zapi service.
 *
 * @see Input
 * @see Output
 * @see Category
 * @see Errno
 * @see Status
 *
 * @author sunday
 * @version $Revision: #2 $ $Date: 2011/06/24 $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
public @interface Api {
    /**
     * The zapi name for this typedef. If not specified,
     * the name will be guessed from class.getSimpleName()
     */
    String value() default "";
}
