/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/CDATA.java#2 $
 *
 * Copyright (c) 2007 Network Appliance, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Hint to the marshaller that the
 * {@link Input}, {@link Output}, or {@link Element}
 * should be wrapped in a CDATA section, rather
 * than xml escaping the field value
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Documented
public @interface CDATA {

}
