/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/DocEnum.java#2 $
 *
 * Copyright (c) 2010 NetApp, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

/**
 * @author sunday
 *
 */
public enum DocEnum {
    /** This element should not be in generated documentation */
    HIDDEN("hidden");

    private final String value;

    private DocEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static DocEnum parse(String doc) {
        doc = doc.trim().toUpperCase();
        return DocEnum.valueOf(doc);
    }

}
