/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/Errno.java#2 $
 *
 * Copyright (c) 2007 Network Appliance, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * Document the expected error return codes for this Zephyr {@link Api}. Because it is legal for a future
 * api version to return additional codes, this should not be considered a complete legal list.
 *
 * @see Api
 * @author sunday
 * @version $Revision: #2 $ $Date: 2011/06/24 $
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
public @interface Errno {
    String[] value();
}
