/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/ErrorCode.java#3 $
 *
 * Copyright (c) 2008 NetApp, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

/**
 * Interface for ErrorEnums where the java enum has an underlying
 * integer status code from the api.
 * @author sunday
 * @version $Revision: #3 $ $Date: 2011/06/24 $
 */
public interface ErrorCode {
    /**
     * Get the numeric error code for this object
     * @return error code
     */
    int getCode();

    /**
     * Test if this enum represents the given code.
     * @param code
     * @return true if this.code == code
     */
    boolean isCode(int code);

    String getName();
}
