/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/GetIterAPIRequest.java#6 $
 *
 * Copyright (c) 2011 NetApp, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

/**
 * Interface for <tt>*-get-iter</tt> {@link APIRequest}s.
 *
 * @param <S> The type of record being iterated over
 */
public interface GetIterAPIRequest<T extends GetIterAPIResponse<?, S>, S> extends APIRequest<T> {

    String getTag();
    void setTag(String tag);
    GetIterAPIRequest<T, S> withTag(String tag);

    S getDesiredAttributes();
    void setDesiredAttributes(S desiredAttributes);
    GetIterAPIRequest<T, S> withDesiredAttributes(S desiredAttributes);

    S getQuery();
    void setQuery(S query);
    GetIterAPIRequest<T, S> withQuery(S query);

    Integer getMaxRecords();
    void setMaxRecords(Integer maxRecords);
    GetIterAPIRequest<T, S> withMaxRecords(Integer maxRecords);

}
