/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/GetIterAPIResponse.java#5 $
 *
 * Copyright (c) 2011 NetApp, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.util.List;

/**
 * Interface for <tt>*-get-iter</tt> {@link APIResponse}s.
 *
 * @param <S> The type of record being iterated over
 */
public interface GetIterAPIResponse<T extends GetIterAPIRequest<?, S>, S> extends APIResponse<T> {

    String getNextTag();
    void setNextTag(String tag);

    Integer getNumRecords();
    void setNumRecords(Integer numRecords);

    List<S> getAttributesList();
    void setAttributesList(List<S> attributes);

}
