/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/Input.java#3 $
 *
 * Copyright (c) 2007 Network Appliance, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Define a Zephyr {@link Api} input parameter.
 * @author sunday
 * @version $Revision: #3 $ $Date: 2011/06/24 $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Documented
public @interface Input {
    /**
     * The zapi element name of this parameter. If not
     * specified, the name will be determined from
     * the java field name.
     */
    String value() default "";
}
