/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/Internable.java#1 $
 *
 * Copyright (c) 2010 NetApp, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * A hint to the unmarshaller that the
 * {@link String} value of a {@link Input}, {@link Output}, or {@link Element}
 * can be interned (via {@link String#intern()}) when unmarshalled.
 * <p/>
 * This typically applies to enumeration-like values, such as option names.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Documented
public @interface Internable {

    /**
     * When not empty, the strings will only be interned if their value matches one of these values.
     *
     * When empty (the default), all strings will be interned.
     */
    String[] values() default {};

}
