/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/GetIterAPIRequest.java#6 $
 *
 * Copyright (c) 2011 NetApp, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

/**
 * Interface for <tt>*-iter</tt> {@link APIRequest}s used by OnCommand.
 *
 * @param <S> The type of record being iterated over.
 */
public interface IterAPIRequest<T extends IterAPIResponse<?, S>, S> extends APIRequest<T> {

    String getTag();
    void setTag(String tag);
    IterAPIRequest<T, S> withTag(String tag);

    Integer getMaxRecords();
    void setMaxRecords(Integer maxRecords);
    IterAPIRequest<T, S> withMaxRecords(Integer maxRecords);

}
