/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/GetIterAPIResponse.java#5 $
 *
 * Copyright (c) 2011 NetApp, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.util.List;

/**
 * Interface for <tt>*-iter</tt> {@link APIResponse}s used by OnCommand.
 *
 * @param <S> The type of record being iterated over
 */
public interface IterAPIResponse<T extends IterAPIRequest<?, S>, S> extends APIResponse<T> {

    String getNextTag();
    void setNextTag(String tag);
    IterAPIResponse<T, S> withNextTag(String tag);

    Integer getNumRecords();
    void setNumRecords(Integer numRecords);
    IterAPIResponse<T, S> withNumRecords(Integer numRecords);

    List<S> getRecords();
    void setRecords(List<S> records);
    IterAPIResponse<T, S> withRecords(List<S> records);

}
