/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/IterStartAPIResponse.java#3 $
 *
 * Copyright (c) 2010 NetApp, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

/**
 * {@link APIResponse}s for *-iter-start apis will implement this interface.
 */
public interface IterStartAPIResponse<T extends APIRequest> extends APIResponse<T> {

    String getTag();
    void setTag(String tag);

    Integer getRecords();
    void setRecords(Integer records);

    /**
     * Create the concrete {@link IterNextAPIRequest} instance corresponding to this {@link IterStartAPIResponse},
     * The returned object will be populated with the iteration tag (from {@link #getTag()}).
     */
    IterNextAPIRequest<?> createIterNextRequest();

    /**
     * Create the concrete {@link IterEndAPIRequest} instance corresponding to this {@link IterStartAPIResponse}.
     * The returned object will be populated with the iteration tag (from {@link #getTag()}).
     */
    IterEndAPIRequest<?> createIterEndRequest();

}

